/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.apacheavro;

import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.apacheavro.AvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SerializerOptions;
import com.azure.data.schemaregistry.models.SchemaFormat;
import com.azure.data.schemaregistry.models.SchemaProperties;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.apache.avro.Schema;
import reactor.core.publisher.Mono;

public final class SchemaRegistryApacheAvroSerializer
implements ObjectSerializer {
    static final byte[] RECORD_FORMAT_INDICATOR = new byte[]{0, 0, 0, 0};
    static final int SCHEMA_ID_SIZE = 32;
    static final int RECORD_FORMAT_INDICATOR_SIZE = 4;
    private final ClientLogger logger = new ClientLogger(SchemaRegistryApacheAvroSerializer.class);
    private final SchemaRegistryAsyncClient schemaRegistryClient;
    private final AvroSerializer avroSerializer;
    private final SerializerOptions serializerOptions;

    SchemaRegistryApacheAvroSerializer(SchemaRegistryAsyncClient schemaRegistryClient, AvroSerializer avroSerializer, SerializerOptions serializerOptions) {
        this.schemaRegistryClient = Objects.requireNonNull(schemaRegistryClient, "'schemaRegistryClient' cannot be null.");
        this.avroSerializer = Objects.requireNonNull(avroSerializer, "'avroSchemaRegistryUtils' cannot be null.");
        this.serializerOptions = Objects.requireNonNull(serializerOptions, "'serializerOptions' cannot be null.");
    }

    public <T> T deserialize(InputStream inputStream, TypeReference<T> typeReference) {
        return (T)this.deserializeAsync(inputStream, typeReference).block();
    }

    public <T> Mono<T> deserializeAsync(InputStream inputStream, TypeReference<T> typeReference) {
        if (inputStream == null) {
            return Mono.empty();
        }
        if (typeReference == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'typeReference' cannot be null."));
        }
        return Mono.fromCallable(() -> {
            byte[] payload = new byte[inputStream.available()];
            while (inputStream.read(payload) != -1) {
            }
            return payload;
        }).flatMap(payload -> {
            if (((byte[])payload).length == 0) {
                return Mono.empty();
            }
            ByteBuffer buffer = ByteBuffer.wrap(payload);
            byte[] recordFormatIndicator = new byte[4];
            buffer.get(recordFormatIndicator);
            if (!Arrays.equals(recordFormatIndicator, RECORD_FORMAT_INDICATOR)) {
                return Mono.error((Throwable)new IllegalStateException("Illegal format: unsupported record format indicator in payload"));
            }
            String schemaId = SchemaRegistryApacheAvroSerializer.getSchemaIdFromPayload(buffer);
            return this.schemaRegistryClient.getSchema(schemaId).handle((registryObject, sink) -> {
                byte[] payloadSchema = registryObject.getDefinition().getBytes(StandardCharsets.UTF_8);
                int start = buffer.position() + buffer.arrayOffset();
                int length = buffer.limit() - 32;
                byte[] b = Arrays.copyOfRange(buffer.array(), start, start + length);
                Object decode = this.avroSerializer.decode(b, payloadSchema, typeReference);
                sink.next(decode);
            });
        });
    }

    public void serialize(OutputStream outputStream, Object object) {
        this.serializeAsync(outputStream, object).block();
    }

    public Mono<Void> serializeAsync(OutputStream outputStream, Object object) {
        Schema schema;
        if (outputStream == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'outputStream' cannot be null."));
        }
        if (object == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("Null object, behavior should be defined in concrete serializer implementation."));
        }
        try {
            schema = AvroSerializer.getSchema(object);
        }
        catch (IllegalArgumentException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
        return this.maybeRegisterSchema(this.serializerOptions.getSchemaGroup(), schema.getFullName(), schema.toString()).handle((id, sink) -> {
            ByteBuffer recordFormatIndicatorBuffer = ByteBuffer.allocate(4).put(new byte[]{0, 0, 0, 0});
            ByteBuffer idBuffer = ByteBuffer.allocate(32).put(id.getBytes(StandardCharsets.UTF_8));
            try {
                outputStream.write(recordFormatIndicatorBuffer.array());
                outputStream.write(idBuffer.array());
                outputStream.write(this.avroSerializer.encode(object));
                sink.complete();
            }
            catch (IOException e) {
                sink.error((Throwable)new UncheckedIOException(e.getMessage(), e));
            }
        });
    }

    private Mono<String> maybeRegisterSchema(String schemaGroup, String schemaName, String schemaString) {
        if (this.serializerOptions.autoRegisterSchemas()) {
            return this.schemaRegistryClient.registerSchema(schemaGroup, schemaName, schemaString, SchemaFormat.AVRO).map(SchemaProperties::getId);
        }
        return this.schemaRegistryClient.getSchemaProperties(schemaGroup, schemaName, schemaString, SchemaFormat.AVRO).map(properties -> properties.getId());
    }

    private static String getSchemaIdFromPayload(ByteBuffer buffer) {
        byte[] schemaGuidByteArray = new byte[32];
        buffer.get(schemaGuidByteArray);
        return new String(schemaGuidByteArray, StandardCharsets.UTF_8);
    }
}

