/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.apacheavro;

import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.apacheavro.AvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SerializerOptions;
import org.apache.avro.Schema;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.EncoderFactory;

public final class SchemaRegistryApacheAvroSerializerBuilder {
    private static final boolean AVRO_SPECIFIC_READER_DEFAULT = false;
    private static final int MAX_CACHE_SIZE = 128;
    private Boolean autoRegisterSchemas = false;
    private Boolean avroSpecificReader = false;
    private SchemaRegistryAsyncClient schemaRegistryAsyncClient;
    private String schemaGroup;

    public SchemaRegistryApacheAvroSerializerBuilder schemaGroup(String schemaGroup) {
        this.schemaGroup = schemaGroup;
        return this;
    }

    public SchemaRegistryApacheAvroSerializerBuilder autoRegisterSchema(boolean autoRegisterSchemas) {
        this.autoRegisterSchemas = autoRegisterSchemas;
        return this;
    }

    public SchemaRegistryApacheAvroSerializerBuilder avroSpecificReader(boolean avroSpecificReader) {
        this.avroSpecificReader = avroSpecificReader;
        return this;
    }

    public SchemaRegistryApacheAvroSerializerBuilder schemaRegistryAsyncClient(SchemaRegistryAsyncClient schemaRegistryAsyncClient) {
        this.schemaRegistryAsyncClient = schemaRegistryAsyncClient;
        return this;
    }

    public SchemaRegistryApacheAvroSerializer buildSerializer() {
        boolean isAutoRegister = this.autoRegisterSchemas != null && this.autoRegisterSchemas != false;
        boolean useAvroSpecificReader = this.avroSpecificReader == null ? false : this.avroSpecificReader;
        Schema.Parser parser = new Schema.Parser();
        AvroSerializer codec = new AvroSerializer(useAvroSpecificReader, parser, EncoderFactory.get(), DecoderFactory.get());
        SerializerOptions options = new SerializerOptions(this.schemaGroup, isAutoRegister, 128);
        return new SchemaRegistryApacheAvroSerializer(this.schemaRegistryAsyncClient, codec, options);
    }
}

