/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.apacheavro;

import com.azure.core.models.MessageContent;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.TypeReference;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.apacheavro.AvroSerializer;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistryApacheAvroException;
import com.azure.data.schemaregistry.apacheavro.SchemaRegistrySchemaCache;
import com.azure.data.schemaregistry.apacheavro.SerializerOptions;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.avro.Schema;
import reactor.core.publisher.Mono;

public final class SchemaRegistryApacheAvroSerializer {
    static final String AVRO_MIME_TYPE = "avro/binary";
    private final ClientLogger logger = new ClientLogger(SchemaRegistryApacheAvroSerializer.class);
    private final AvroSerializer avroSerializer;
    private final SchemaRegistrySchemaCache schemaCache;

    SchemaRegistryApacheAvroSerializer(SchemaRegistryAsyncClient schemaRegistryClient, AvroSerializer avroSerializer, SerializerOptions serializerOptions) {
        Objects.requireNonNull(schemaRegistryClient, "'schemaRegistryClient' cannot be null.");
        Objects.requireNonNull(serializerOptions, "'serializerOptions' cannot be null.");
        this.avroSerializer = Objects.requireNonNull(avroSerializer, "'avroSerializer' cannot be null.");
        this.schemaCache = new SchemaRegistrySchemaCache(schemaRegistryClient, serializerOptions.getSchemaGroup(), serializerOptions.autoRegisterSchemas(), serializerOptions.getMaxCacheSize());
    }

    public <T extends MessageContent> T serialize(Object object, TypeReference<T> typeReference) {
        return (T)((MessageContent)this.serializeAsync(object, typeReference).block());
    }

    public <T extends MessageContent> T serialize(Object object, TypeReference<T> typeReference, Function<BinaryData, T> messageFactory) {
        return (T)((MessageContent)this.serializeAsync(object, typeReference, messageFactory).block());
    }

    public <T extends MessageContent> Mono<T> serializeAsync(Object object, TypeReference<T> typeReference) {
        return this.serializeAsync(object, typeReference, null);
    }

    public <T extends MessageContent> Mono<T> serializeAsync(Object object, TypeReference<T> typeReference, Function<BinaryData, T> messageFactory) {
        Schema schema;
        if (object == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("Null object, behavior should be defined in concrete serializer implementation."));
        }
        if (typeReference == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'typeReference' cannot be null."));
        }
        Optional<Constructor> constructor = Arrays.stream(typeReference.getJavaClass().getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst();
        if (!constructor.isPresent() && messageFactory == null) {
            return Mono.error((Throwable)new IllegalArgumentException(typeReference.getJavaClass() + "does not have have a no-arg constructor to create a new instance of T with. Use the overload that accepts 'messageFactory'."));
        }
        Function<BinaryData, Object> messageFactoryToUse = messageFactory != null ? messageFactory : binaryData -> {
            Object instance = SchemaRegistryApacheAvroSerializer.createNoArgumentInstance(typeReference);
            instance.setBodyAsBinaryData(binaryData);
            return instance;
        };
        try {
            schema = AvroSerializer.getSchema(object);
        }
        catch (IllegalArgumentException exception) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)exception);
        }
        return this.schemaCache.getSchemaId(schema).handle((schemaId, sink) -> {
            try {
                byte[] encoded = this.avroSerializer.serialize(object, (String)schemaId);
                MessageContent serializedMessage = (MessageContent)messageFactoryToUse.apply(BinaryData.fromBytes((byte[])encoded));
                serializedMessage.setContentType("avro/binary+" + schemaId);
                sink.next((Object)serializedMessage);
                sink.complete();
            }
            catch (SchemaRegistryApacheAvroException e) {
                sink.error((Throwable)((Object)e));
            }
            catch (Exception e) {
                sink.error((Throwable)((Object)new SchemaRegistryApacheAvroException(String.format("Error encountered serializing object: %s with schemaId '%s'.", object, schemaId), e, (String)schemaId)));
            }
        });
    }

    public <T> T deserialize(MessageContent message, TypeReference<T> typeReference) {
        return (T)this.deserializeAsync(message, typeReference).block();
    }

    public <T> Mono<T> deserializeAsync(MessageContent message, TypeReference<T> typeReference) {
        if (message == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'message' cannot be null."));
        }
        if (typeReference == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("'typeReference' cannot be null."));
        }
        BinaryData body = message.getBodyAsBinaryData();
        if (Objects.isNull(body)) {
            this.logger.warning("Message provided does not have a BinaryBody, returning empty response.");
            return Mono.empty();
        }
        ByteBuffer contents = body.toByteBuffer();
        if (contents.remaining() == 0) {
            this.logger.warning("Message provided has an empty BinaryBody, returning empty response.");
            return Mono.empty();
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)message.getContentType())) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Cannot deserialize message with no content-type."));
        }
        String[] parts = message.getContentType().split("\\+");
        if (parts.length != 2) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("Content type was not in the expected format of MIME type + schema ID. Actual: " + message.getContentType()));
        }
        if (!AVRO_MIME_TYPE.equalsIgnoreCase(parts[0])) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new IllegalArgumentException("An avro encoder may only be used on content that is of 'avro/binary' type. Actual: " + message.getContentType()));
        }
        String schemaId = parts[1];
        return this.schemaCache.getSchema(schemaId).handle((schema, sink) -> {
            try {
                Object decode = this.avroSerializer.deserialize(contents, (Schema)schema, typeReference);
                sink.next(decode);
            }
            catch (Exception e) {
                sink.error((Throwable)e);
            }
        });
    }

    private static <T extends MessageContent> T createNoArgumentInstance(TypeReference<T> typeReference) {
        Object newObject;
        Optional<Constructor> constructor = Arrays.stream(typeReference.getJavaClass().getDeclaredConstructors()).filter(c -> c.getParameterCount() == 0).findFirst();
        if (!constructor.isPresent()) {
            throw new IllegalArgumentException(typeReference.getJavaClass() + "does not have have a no-arg constructor to create a new instance of T with. Use the overload that accepts 'messageFactory'.");
        }
        try {
            newObject = constructor.get().newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Could not instantiate '%s' with no-arg constructor.", typeReference.getJavaClass()), e);
        }
        if (!typeReference.getJavaClass().isInstance(newObject)) {
            throw new RuntimeException(String.format("Constructed '%s' object was not an instanceof T '%s'.", newObject, typeReference.getJavaClass()));
        }
        return (T)((MessageContent)newObject);
    }
}

