/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.avro;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.schemaregistry.avro.AvroSchemaUtils;
import com.azure.data.schemaregistry.models.SerializationType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.specific.SpecificRecord;

class AvroSchemaRegistryUtils {
    private final ClientLogger logger = new ClientLogger(AvroSchemaRegistryUtils.class);
    private static final EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    private static final DecoderFactory DECODER_FACTORY = DecoderFactory.get();
    private static final Boolean AVRO_SPECIFIC_READER_DEFAULT = false;
    private final Boolean avroSpecificReader;

    AvroSchemaRegistryUtils(Boolean avroSpecificReader) {
        this.avroSpecificReader = avroSpecificReader == null ? AVRO_SPECIFIC_READER_DEFAULT : avroSpecificReader;
    }

    SerializationType getSerializationType() {
        return SerializationType.AVRO;
    }

    Schema parseSchemaString(String schemaString) {
        return new Schema.Parser().parse(schemaString);
    }

    String getSchemaString(Object object) {
        Schema schema = AvroSchemaUtils.getSchema(object);
        return schema.toString();
    }

    String getSchemaName(Object object) {
        return AvroSchemaUtils.getSchema(object).getFullName();
    }

    String getSchemaGroup() {
        return "$Default";
    }

    byte[] encode(Object object) {
        Schema schema = AvroSchemaUtils.getSchema(object);
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (object instanceof byte[]) {
                out.write((byte[])object);
            } else {
                BinaryEncoder encoder = ENCODER_FACTORY.directBinaryEncoder((OutputStream)out, null);
                Object writer = object instanceof SpecificRecord ? new SpecificDatumWriter(schema) : new GenericDatumWriter(schema);
                writer.write(object, (Encoder)encoder);
                encoder.flush();
            }
            return out.toByteArray();
        }
        catch (IOException | RuntimeException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Error serializing Avro message", e));
        }
    }

    <T> T decode(byte[] b, byte[] schemaBytes) {
        Objects.requireNonNull(schemaBytes, "Schema must not be null.");
        String schemaString = new String(schemaBytes, StandardCharsets.UTF_8);
        Schema schemaObject = this.parseSchemaString(schemaString);
        DatumReader<T> reader = this.getDatumReader(schemaObject);
        try {
            Object result = reader.read(null, (Decoder)DECODER_FACTORY.binaryDecoder(b, null));
            return (T)result;
        }
        catch (IOException | RuntimeException e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Error deserializing Avro message.", e));
        }
    }

    private <T> DatumReader<T> getDatumReader(Schema writerSchema) {
        boolean writerSchemaIsPrimitive = AvroSchemaUtils.getPrimitiveSchemas().values().contains(writerSchema);
        if (this.avroSpecificReader.booleanValue() && !writerSchemaIsPrimitive) {
            return new SpecificDatumReader(writerSchema);
        }
        return new GenericDatumReader(writerSchema);
    }
}

