/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.avro;

import com.azure.core.util.logging.ClientLogger;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;

class AvroSchemaUtils {
    private static final Map<String, Schema> PRIMITIVE_SCHEMAS;

    AvroSchemaUtils() {
    }

    private static Schema createPrimitiveSchema(Schema.Parser parser, String type) {
        String schemaString = String.format("{\"type\" : \"%s\"}", type);
        return parser.parse(schemaString);
    }

    public static Map<String, Schema> getPrimitiveSchemas() {
        return Collections.unmodifiableMap(PRIMITIVE_SCHEMAS);
    }

    public static Schema getSchema(Object object) throws IllegalArgumentException {
        if (object == null) {
            return PRIMITIVE_SCHEMAS.get("Null");
        }
        if (object instanceof Boolean) {
            return PRIMITIVE_SCHEMAS.get("Boolean");
        }
        if (object instanceof Integer) {
            return PRIMITIVE_SCHEMAS.get("Integer");
        }
        if (object instanceof Long) {
            return PRIMITIVE_SCHEMAS.get("Long");
        }
        if (object instanceof Float) {
            return PRIMITIVE_SCHEMAS.get("Float");
        }
        if (object instanceof Double) {
            return PRIMITIVE_SCHEMAS.get("Double");
        }
        if (object instanceof CharSequence) {
            return PRIMITIVE_SCHEMAS.get("String");
        }
        if (object instanceof byte[] || object instanceof ByteBuffer) {
            return PRIMITIVE_SCHEMAS.get("Bytes");
        }
        if (object instanceof GenericContainer) {
            return ((GenericContainer)object).getSchema();
        }
        ClientLogger logger = new ClientLogger(AvroSchemaUtils.class);
        throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Unsupported Avro type. Supported types are null, Boolean, Integer, Long, Float, Double, String, byte[] and IndexedRecord"));
    }

    static {
        Schema.Parser parser = new Schema.Parser();
        PRIMITIVE_SCHEMAS = new HashMap<String, Schema>();
        PRIMITIVE_SCHEMAS.put("Null", AvroSchemaUtils.createPrimitiveSchema(parser, "null"));
        PRIMITIVE_SCHEMAS.put("Boolean", AvroSchemaUtils.createPrimitiveSchema(parser, "boolean"));
        PRIMITIVE_SCHEMAS.put("Integer", AvroSchemaUtils.createPrimitiveSchema(parser, "int"));
        PRIMITIVE_SCHEMAS.put("Long", AvroSchemaUtils.createPrimitiveSchema(parser, "long"));
        PRIMITIVE_SCHEMAS.put("Float", AvroSchemaUtils.createPrimitiveSchema(parser, "float"));
        PRIMITIVE_SCHEMAS.put("Double", AvroSchemaUtils.createPrimitiveSchema(parser, "double"));
        PRIMITIVE_SCHEMAS.put("String", AvroSchemaUtils.createPrimitiveSchema(parser, "string"));
        PRIMITIVE_SCHEMAS.put("Bytes", AvroSchemaUtils.createPrimitiveSchema(parser, "bytes"));
    }
}

