/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.models.SchemaProperties;
import com.azure.data.schemaregistry.models.SerializationType;

public final class SchemaRegistryClient {
    private final SchemaRegistryAsyncClient asyncClient;

    SchemaRegistryClient(SchemaRegistryAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public SchemaProperties registerSchema(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType) {
        return (SchemaProperties)this.registerSchemaWithResponse(schemaGroup, schemaName, schemaString, serializationType, Context.NONE).getValue();
    }

    public Response<SchemaProperties> registerSchemaWithResponse(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType, Context context) {
        return (Response)this.asyncClient.registerSchemaWithResponse(schemaGroup, schemaName, schemaString, serializationType, context).block();
    }

    public SchemaProperties getSchema(String schemaId) {
        return (SchemaProperties)this.getSchemaWithResponse(schemaId, Context.NONE).getValue();
    }

    public Response<SchemaProperties> getSchemaWithResponse(String schemaId, Context context) {
        return (Response)this.asyncClient.getSchemaWithResponse(schemaId).block();
    }

    public String getSchemaId(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType) {
        return (String)this.getSchemaIdWithResponse(schemaGroup, schemaName, schemaString, serializationType, Context.NONE).getValue();
    }

    public Response<String> getSchemaIdWithResponse(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType, Context context) {
        return (Response)this.asyncClient.getSchemaIdWithResponse(schemaGroup, schemaName, schemaString, serializationType, context).block();
    }

    void clearCache() {
        this.asyncClient.clearCache();
    }
}

