/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.SchemaRegistryClient;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistry;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;

@ServiceClientBuilder(serviceClients={SchemaRegistryAsyncClient.class})
public class SchemaRegistryClientBuilder {
    private final ClientLogger logger = new ClientLogger(SchemaRegistryClientBuilder.class);
    private static final String DEFAULT_SCOPE = "https://eventhubs.azure.net/.default";
    private static final String CLIENT_PROPERTIES = "azure-data-schemaregistry-client.properties";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
    private final ConcurrentSkipListMap<String, Function<String, Object>> typeParserMap;
    private final List<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
    private final String clientName;
    private final String clientVersion;
    private String schemaRegistryUrl;
    private String host;
    private HttpClient httpClient = null;
    private Integer maxSchemaMapSize = null;
    private TokenCredential credential = null;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private RetryPolicy retryPolicy;

    public SchemaRegistryClientBuilder() {
        this.typeParserMap = new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER);
        this.retryPolicy = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
        HttpHeaders headers = new HttpHeaders();
        headers.put("api-version", "2020-09-01-preview");
        this.policies.add((HttpPipelinePolicy)new AddHeadersPolicy(headers));
        Map properties = CoreUtils.getProperties((String)CLIENT_PROPERTIES);
        this.clientName = properties.getOrDefault(NAME, "UnknownName");
        this.clientVersion = properties.getOrDefault(VERSION, "UnknownVersion");
    }

    public SchemaRegistryClientBuilder endpoint(String schemaRegistryUrl) {
        Objects.requireNonNull(schemaRegistryUrl, "'schemaRegistryUrl' cannot be null.");
        try {
            URL url = new URL(schemaRegistryUrl);
            this.host = url.getHost();
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'schemaRegistryUrl' must be a valid URL.", ex));
        }
        this.schemaRegistryUrl = schemaRegistryUrl.endsWith("/") ? schemaRegistryUrl.substring(0, schemaRegistryUrl.length() - 1) : schemaRegistryUrl;
        return this;
    }

    public SchemaRegistryClientBuilder maxCacheSize(int maxCacheSize) {
        if (maxCacheSize < 10) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Schema map size must be greater than %s entries", 10)));
        }
        this.maxSchemaMapSize = maxCacheSize;
        return this;
    }

    public SchemaRegistryClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public SchemaRegistryClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SchemaRegistryClientBuilder credential(TokenCredential credential) {
        this.credential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public SchemaRegistryClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public SchemaRegistryClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SchemaRegistryClientBuilder addPolicy(HttpPipelinePolicy policy) {
        this.policies.add(Objects.requireNonNull(policy, "'policy' cannot be null."));
        return this;
    }

    public SchemaRegistryAsyncClient buildAsyncClient() {
        if (this.credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing credential information while building a client."));
        }
        HttpPipeline pipeline = this.httpPipeline;
        if (pipeline == null) {
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(this.httpLogOptions.getApplicationId(), this.clientName, this.clientVersion, Configuration.getGlobalConfiguration().clone()));
            policies.add(new RequestIdPolicy());
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(this.retryPolicy == null ? DEFAULT_RETRY_POLICY : this.retryPolicy);
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(this.credential, new String[]{DEFAULT_SCOPE}));
            policies.addAll(this.policies);
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            pipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).build();
        }
        AzureSchemaRegistry restService = new AzureSchemaRegistryBuilder().endpoint(this.host).pipeline(pipeline).buildClient();
        this.maxSchemaMapSize = this.maxSchemaMapSize != null ? this.maxSchemaMapSize : 1000;
        return new SchemaRegistryAsyncClient(restService, this.maxSchemaMapSize, this.typeParserMap);
    }

    public SchemaRegistryClient buildClient() {
        return new SchemaRegistryClient(this.buildAsyncClient());
    }
}

