/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.models;

import com.azure.data.schemaregistry.models.SerializationType;
import java.util.Arrays;

public final class SchemaProperties {
    private final String schemaId;
    private final SerializationType serializationType;
    private final byte[] schemaBytes;
    private final String schemaName;

    public SchemaProperties(String schemaId, SerializationType serializationType, String schemaName, byte[] schemaByteArray) {
        this.schemaId = schemaId;
        this.serializationType = serializationType;
        this.schemaBytes = (byte[])schemaByteArray.clone();
        this.schemaName = schemaName;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public SerializationType getSerializationType() {
        return this.serializationType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public byte[] getSchema() {
        if (this.schemaBytes == null) {
            return new byte[0];
        }
        return Arrays.copyOf(this.schemaBytes, this.schemaBytes.length);
    }
}

