/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.models.SchemaProperties;
import com.azure.data.schemaregistry.models.SerializationType;

@ServiceClient(builder=SchemaRegistryClientBuilder.class)
public final class SchemaRegistryClient {
    private final SchemaRegistryAsyncClient asyncClient;

    SchemaRegistryClient(SchemaRegistryAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaProperties registerSchema(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType) {
        return (SchemaProperties)this.asyncClient.registerSchema(schemaGroup, schemaName, schemaString, serializationType).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaProperties> registerSchemaWithResponse(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType, Context context) {
        return (Response)this.asyncClient.registerSchemaWithResponse(schemaGroup, schemaName, schemaString, serializationType, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaProperties getSchema(String schemaId) {
        return (SchemaProperties)this.asyncClient.getSchema(schemaId).block();
    }

    Response<SchemaProperties> getSchemaWithResponse(String schemaId, Context context) {
        return (Response)this.asyncClient.getSchemaWithResponse(schemaId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getSchemaId(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType) {
        return (String)this.asyncClient.getSchemaId(schemaGroup, schemaName, schemaString, serializationType).block();
    }

    Response<String> getSchemaIdWithResponse(String schemaGroup, String schemaName, String schemaString, SerializationType serializationType, Context context) {
        return (Response)this.asyncClient.getSchemaIdWithResponse(schemaGroup, schemaName, schemaString, serializationType, context).block();
    }

    void clearCache() {
        this.asyncClient.clearCache();
    }
}

