/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.exception.ResourceNotFoundException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistry;
import com.azure.data.schemaregistry.implementation.models.SchemaId;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterResponse;
import com.azure.data.schemaregistry.implementation.models.SerializationType;
import com.azure.data.schemaregistry.implementation.models.ServiceErrorResponseException;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

public final class Schemas {
    private final SchemasService service;
    private final AzureSchemaRegistry client;

    Schemas(AzureSchemaRegistry client) {
        this.service = (SchemasService)RestProxy.create(SchemasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasGetByIdResponse> getByIdWithResponseAsync(String schemaId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (schemaId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaId is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.getById(this.client.getEndpoint(), schemaId, this.client.getApiVersion(), (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<String> getByIdAsync(String schemaId) {
        return this.getByIdWithResponseAsync(schemaId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)new String(res.getValue(), StandardCharsets.UTF_8));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public String getById(String schemaId) {
        return (String)this.getByIdAsync(schemaId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasQueryIdByContentResponse> queryIdByContentWithResponseAsync(String groupName, String schemaName, SerializationType xSchemaType, String schemaContent) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (xSchemaType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter xSchemaType is required and cannot be null."));
        }
        if (schemaContent == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaContent is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.queryIdByContent(this.client.getEndpoint(), groupName, schemaName, xSchemaType, this.client.getApiVersion(), schemaContent, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaId> queryIdByContentAsync(String groupName, String schemaName, SerializationType xSchemaType, String schemaContent) {
        return this.queryIdByContentWithResponseAsync(groupName, schemaName, xSchemaType, schemaContent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaId queryIdByContent(String groupName, String schemaName, SerializationType xSchemaType, String schemaContent) {
        return (SchemaId)this.queryIdByContentAsync(groupName, schemaName, xSchemaType, schemaContent).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasRegisterResponse> registerWithResponseAsync(String groupName, String schemaName, SerializationType xSchemaType, String schemaContent) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (groupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter groupName is required and cannot be null."));
        }
        if (schemaName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaName is required and cannot be null."));
        }
        if (xSchemaType == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter xSchemaType is required and cannot be null."));
        }
        if (schemaContent == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter schemaContent is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.register(this.client.getEndpoint(), groupName, schemaName, xSchemaType, this.client.getApiVersion(), schemaContent, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemaId> registerAsync(String groupName, String schemaName, SerializationType xSchemaType, String schemaContent) {
        return this.registerWithResponseAsync(groupName, schemaName, xSchemaType, schemaContent).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaId register(String groupName, String schemaName, SerializationType xSchemaType, String schemaContent) {
        return (SchemaId)this.registerAsync(groupName, schemaName, xSchemaType, schemaContent).block();
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="AzureSchemaRegistryS")
    private static interface SchemasService {
        @Get(value="/$schemagroups/getSchemaById/{schema-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=ServiceErrorResponseException.class)})
        public Mono<SchemasGetByIdResponse> getById(@HostParam(value="endpoint") String var1, @PathParam(value="schema-id") String var2, @QueryParam(value="api-version") String var3, Context var4);

        @Post(value="/$schemagroups/{group-name}/schemas/{schema-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(code={404}, value=ResourceNotFoundException.class), @UnexpectedResponseExceptionType(value=ServiceErrorResponseException.class)})
        public Mono<SchemasQueryIdByContentResponse> queryIdByContent(@HostParam(value="endpoint") String var1, @PathParam(value="group-name") String var2, @PathParam(value="schema-name") String var3, @HeaderParam(value="Serialization-Type") SerializationType var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") String var6, Context var7);

        @Put(value="/$schemagroups/{group-name}/schemas/{schema-name}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceErrorResponseException.class)
        public Mono<SchemasRegisterResponse> register(@HostParam(value="endpoint") String var1, @PathParam(value="group-name") String var2, @PathParam(value="schema-name") String var3, @HeaderParam(value="Serialization-Type") SerializationType var4, @QueryParam(value="api-version") String var5, @BodyParam(value="text/plain; charset=utf-8") String var6, Context var7);
    }
}

