/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterResponse;
import com.azure.data.schemaregistry.models.SchemaFormat;
import com.azure.data.schemaregistry.models.SchemaProperties;
import java.util.Objects;

public final class SchemaRegistryHelper {
    private static SchemaRegistryModelsAccessor accessor;

    public static void setAccessor(SchemaRegistryModelsAccessor modelsAccessor) {
        accessor = Objects.requireNonNull(modelsAccessor, "'modelsAccessor' cannot be null.");
    }

    public static SchemaProperties getSchemaProperties(SchemasRegisterResponse response) {
        SchemasRegisterHeaders headers = (SchemasRegisterHeaders)response.getDeserializedHeaders();
        return accessor.getSchemaProperties(headers.getSchemaId(), SchemaFormat.AVRO, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasGetByIdResponse response) {
        SchemasGetByIdHeaders headers = (SchemasGetByIdHeaders)response.getDeserializedHeaders();
        return accessor.getSchemaProperties(headers.getSchemaId(), SchemaFormat.AVRO, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasQueryIdByContentResponse response) {
        SchemasQueryIdByContentHeaders headers = (SchemasQueryIdByContentHeaders)response.getDeserializedHeaders();
        return accessor.getSchemaProperties(headers.getSchemaId(), SchemaFormat.AVRO, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasGetSchemaVersionResponse response) {
        SchemasGetSchemaVersionHeaders headers = (SchemasGetSchemaVersionHeaders)response.getDeserializedHeaders();
        return accessor.getSchemaProperties(headers.getSchemaId(), SchemaFormat.AVRO, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static interface SchemaRegistryModelsAccessor {
        public SchemaProperties getSchemaProperties(String var1, SchemaFormat var2, String var3, String var4, int var5);
    }
}

