/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImpl;
import com.azure.data.schemaregistry.implementation.models.ErrorException;
import com.azure.data.schemaregistry.implementation.models.SchemaVersions;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterResponse;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SchemasImpl {
    private final SchemasService service;
    private final AzureSchemaRegistryImpl client;

    SchemasImpl(AzureSchemaRegistryImpl client) {
        this.service = (SchemasService)RestProxy.create(SchemasService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasGetByIdResponse> getByIdWithResponseAsync(String id, Context context) {
        String accept = "application/json; serialization=Avro";
        return this.service.getById(this.client.getEndpoint(), id, this.client.getApiVersion(), "application/json; serialization=Avro", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SchemaVersions>> getVersionsWithResponseAsync(String groupName, String schemaName, Context context) {
        String accept = "application/json";
        return this.service.getVersions(this.client.getEndpoint(), groupName, schemaName, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasGetSchemaVersionResponse> getSchemaVersionWithResponseAsync(String groupName, String schemaName, int schemaVersion, Context context) {
        String accept = "application/json";
        return this.service.getSchemaVersion(this.client.getEndpoint(), groupName, schemaName, schemaVersion, this.client.getApiVersion(), "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasQueryIdByContentResponse> queryIdByContentWithResponseAsync(String groupName, String schemaName, Flux<ByteBuffer> schemaContent, long contentLength, Context context) {
        String accept = "application/json";
        return this.service.queryIdByContent(this.client.getEndpoint(), groupName, schemaName, this.client.getApiVersion(), schemaContent, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasQueryIdByContentResponse> queryIdByContentWithResponseAsync(String groupName, String schemaName, BinaryData schemaContent, long contentLength, Context context) {
        String accept = "application/json";
        return this.service.queryIdByContent(this.client.getEndpoint(), groupName, schemaName, this.client.getApiVersion(), schemaContent, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasRegisterResponse> registerWithResponseAsync(String groupName, String schemaName, Flux<ByteBuffer> schemaContent, long contentLength, Context context) {
        String accept = "application/json";
        return this.service.register(this.client.getEndpoint(), groupName, schemaName, this.client.getApiVersion(), schemaContent, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SchemasRegisterResponse> registerWithResponseAsync(String groupName, String schemaName, BinaryData schemaContent, long contentLength, Context context) {
        String accept = "application/json";
        return this.service.register(this.client.getEndpoint(), groupName, schemaName, this.client.getApiVersion(), schemaContent, contentLength, "application/json", context);
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="AzureSchemaRegistryS")
    public static interface SchemasService {
        @Get(value="/$schemaGroups/$schemas/{id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<SchemasGetByIdResponse> getById(@HostParam(value="endpoint") String var1, @PathParam(value="id") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/$schemaGroups/{groupName}/schemas/{schemaName}/versions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<SchemaVersions>> getVersions(@HostParam(value="endpoint") String var1, @PathParam(value="groupName") String var2, @PathParam(value="schemaName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/$schemaGroups/{groupName}/schemas/{schemaName}/versions/{schemaVersion}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<SchemasGetSchemaVersionResponse> getSchemaVersion(@HostParam(value="endpoint") String var1, @PathParam(value="groupName") String var2, @PathParam(value="schemaName") String var3, @PathParam(value="schemaVersion") int var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/$schemaGroups/{groupName}/schemas/{schemaName}:get-id")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ErrorException.class, code={415}), @UnexpectedResponseExceptionType(value=ErrorException.class)})
        public Mono<SchemasQueryIdByContentResponse> queryIdByContent(@HostParam(value="endpoint") String var1, @PathParam(value="groupName") String var2, @PathParam(value="schemaName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json; serialization=Avro") Flux<ByteBuffer> var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Accept") String var8, Context var9);

        @Post(value="/$schemaGroups/{groupName}/schemas/{schemaName}:get-id")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ErrorException.class, code={415}), @UnexpectedResponseExceptionType(value=ErrorException.class)})
        public Mono<SchemasQueryIdByContentResponse> queryIdByContent(@HostParam(value="endpoint") String var1, @PathParam(value="groupName") String var2, @PathParam(value="schemaName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json; serialization=Avro") BinaryData var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/$schemaGroups/{groupName}/schemas/{schemaName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ErrorException.class, code={415}), @UnexpectedResponseExceptionType(value=ErrorException.class)})
        public Mono<SchemasRegisterResponse> register(@HostParam(value="endpoint") String var1, @PathParam(value="groupName") String var2, @PathParam(value="schemaName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json; serialization=Avro") Flux<ByteBuffer> var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Accept") String var8, Context var9);

        @Put(value="/$schemaGroups/{groupName}/schemas/{schemaName}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=ErrorException.class, code={415}), @UnexpectedResponseExceptionType(value=ErrorException.class)})
        public Mono<SchemasRegisterResponse> register(@HostParam(value="endpoint") String var1, @PathParam(value="groupName") String var2, @PathParam(value="schemaName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json; serialization=Avro") BinaryData var5, @HeaderParam(value="Content-Length") long var6, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

