/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.models.SchemaFormat;
import com.azure.data.schemaregistry.models.SchemaProperties;
import com.azure.data.schemaregistry.models.SchemaRegistrySchema;

@ServiceClient(builder=SchemaRegistryClientBuilder.class)
public final class SchemaRegistryClient {
    private final SchemaRegistryAsyncClient asyncClient;

    SchemaRegistryClient(SchemaRegistryAsyncClient asyncClient) {
        this.asyncClient = asyncClient;
    }

    public String getFullyQualifiedNamespace() {
        return this.asyncClient.getFullyQualifiedNamespace();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaProperties registerSchema(String groupName, String name, String schemaDefinition, SchemaFormat format) {
        return (SchemaProperties)this.asyncClient.registerSchema(groupName, name, schemaDefinition, format).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaProperties> registerSchemaWithResponse(String groupName, String name, String schemaDefinition, SchemaFormat format, Context context) {
        return (Response)this.asyncClient.registerSchemaWithResponse(groupName, name, schemaDefinition, format, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaRegistrySchema getSchema(String schemaId) {
        return (SchemaRegistrySchema)this.asyncClient.getSchema(schemaId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaRegistrySchema getSchema(String groupName, String schemaName, int schemaVersion) {
        return (SchemaRegistrySchema)this.asyncClient.getSchema(groupName, schemaName, schemaVersion).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaRegistrySchema> getSchemaWithResponse(String schemaId, Context context) {
        return (Response)this.asyncClient.getSchemaWithResponse(schemaId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaRegistrySchema> getSchemaWithResponse(String groupName, String schemaName, int schemaVersion, Context context) {
        return (Response)this.asyncClient.getSchemaWithResponse(groupName, schemaName, schemaVersion, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaProperties getSchemaProperties(String groupName, String name, String schemaDefinition, SchemaFormat format) {
        return (SchemaProperties)this.asyncClient.getSchemaProperties(groupName, name, schemaDefinition, format).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaProperties> getSchemaPropertiesWithResponse(String groupName, String name, String schemaDefinition, SchemaFormat format, Context context) {
        return (Response)this.asyncClient.getSchemaPropertiesWithResponse(groupName, name, schemaDefinition, format, context).block();
    }
}

