// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.schemaregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** Error response returned from Azure Schema Registry service. */
@Fluent
public final class ErrorDetail {
    /*
     * Server-defined error code.
     */
    @JsonProperty(value = "code", required = true)
    private String code;

    /*
     * Brief description of error.
     */
    @JsonProperty(value = "message", required = true)
    private String message;

    /*
     * Error message details to help user understand/debug failure.
     */
    @JsonProperty(value = "details")
    private List<ErrorDetail> details;

    /** Creates an instance of ErrorDetail class. */
    public ErrorDetail() {}

    /**
     * Get the code property: Server-defined error code.
     *
     * @return the code value.
     */
    public String getCode() {
        return this.code;
    }

    /**
     * Set the code property: Server-defined error code.
     *
     * @param code the code value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setCode(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get the message property: Brief description of error.
     *
     * @return the message value.
     */
    public String getMessage() {
        return this.message;
    }

    /**
     * Set the message property: Brief description of error.
     *
     * @param message the message value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the details property: Error message details to help user understand/debug failure.
     *
     * @return the details value.
     */
    public List<ErrorDetail> getDetails() {
        return this.details;
    }

    /**
     * Set the details property: Error message details to help user understand/debug failure.
     *
     * @param details the details value to set.
     * @return the ErrorDetail object itself.
     */
    public ErrorDetail setDetails(List<ErrorDetail> details) {
        this.details = details;
        return this;
    }
}
