// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.schemaregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** Object received from the registry containing the list of schema groups and link to next batch page. */
@Fluent
public final class SchemaGroups {
    /*
     * Array of schema groups.
     */
    @JsonProperty(value = "schemaGroups")
    private List<String> groups;

    /*
     * URl to next batch of schema groups
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of SchemaGroups class. */
    public SchemaGroups() {}

    /**
     * Get the groups property: Array of schema groups.
     *
     * @return the groups value.
     */
    public List<String> getGroups() {
        return this.groups;
    }

    /**
     * Set the groups property: Array of schema groups.
     *
     * @param groups the groups value to set.
     * @return the SchemaGroups object itself.
     */
    public SchemaGroups setGroups(List<String> groups) {
        this.groups = groups;
        return this;
    }

    /**
     * Get the nextLink property: URl to next batch of schema groups.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URl to next batch of schema groups.
     *
     * @param nextLink the nextLink value to set.
     * @return the SchemaGroups object itself.
     */
    public SchemaGroups setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }
}
