// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.schemaregistry.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** Object received from the registry containing the list of schema versions and link to next batch page. */
@Fluent
public final class SchemaVersions {
    /*
     * Array of schema version integers.
     */
    @JsonProperty(value = "schemaVersions")
    private List<Integer> versions;

    /*
     * URl to next batch of schema versions
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /** Creates an instance of SchemaVersions class. */
    public SchemaVersions() {}

    /**
     * Get the versions property: Array of schema version integers.
     *
     * @return the versions value.
     */
    public List<Integer> getVersions() {
        return this.versions;
    }

    /**
     * Set the versions property: Array of schema version integers.
     *
     * @param versions the versions value to set.
     * @return the SchemaVersions object itself.
     */
    public SchemaVersions setVersions(List<Integer> versions) {
        this.versions = versions;
        return this;
    }

    /**
     * Get the nextLink property: URl to next batch of schema versions.
     *
     * @return the nextLink value.
     */
    public String getNextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URl to next batch of schema versions.
     *
     * @param nextLink the nextLink value to set.
     * @return the SchemaVersions object itself.
     */
    public SchemaVersions setNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }
}
