/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImpl;
import com.azure.data.schemaregistry.implementation.models.ErrorException;
import com.azure.data.schemaregistry.implementation.models.SchemaGroups;
import reactor.core.publisher.Mono;

public final class SchemaGroupsOperationsImpl {
    private final SchemaGroupsService service;
    private final AzureSchemaRegistryImpl client;

    SchemaGroupsOperationsImpl(AzureSchemaRegistryImpl client) {
        this.service = (SchemaGroupsService)RestProxy.create(SchemaGroupsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> listSinglePageAsync(Context context) {
        String accept = "application/json";
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SchemaGroups)res.getValue()).getGroups(), ((SchemaGroups)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listAsync() {
        return this.listAsync(Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<String> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<String>> listNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SchemaGroups)res.getValue()).getGroups(), ((SchemaGroups)res.getValue()).getNextLink(), null));
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="AzureSchemaRegistryS")
    public static interface SchemaGroupsService {
        @Get(value="/$schemaGroups")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<SchemaGroups>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorException.class)
        public Mono<Response<SchemaGroups>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

