/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.core.http.HttpHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemaFormatImpl;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentResponse;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterResponse;
import com.azure.data.schemaregistry.models.SchemaFormat;
import com.azure.data.schemaregistry.models.SchemaProperties;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

public final class SchemaRegistryHelper {
    private static final HashMap<String, SchemaFormatImpl> SCHEMA_FORMAT_HASH_MAP = new HashMap();
    private static final Pattern SCHEMA_FORMAT_PATTERN = Pattern.compile("\\s");
    private static SchemaRegistryModelsAccessor accessor;

    public static void setAccessor(SchemaRegistryModelsAccessor modelsAccessor) {
        accessor = Objects.requireNonNull(modelsAccessor, "'modelsAccessor' cannot be null.");
    }

    public static SchemaProperties getSchemaProperties(SchemasRegisterResponse response, SchemaFormat fallbackFormat) {
        SchemasRegisterHeaders headers = (SchemasRegisterHeaders)response.getDeserializedHeaders();
        SchemaFormat responseFormat = SchemaRegistryHelper.getSchemaFormat(response.getHeaders());
        SchemaFormat schemaFormat = responseFormat != null ? responseFormat : fallbackFormat;
        return accessor.getSchemaProperties(headers.getSchemaId(), schemaFormat, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasGetByIdResponse response) {
        SchemasGetByIdHeaders headers = (SchemasGetByIdHeaders)response.getDeserializedHeaders();
        SchemaFormat schemaFormat = SchemaRegistryHelper.getSchemaFormat(response.getHeaders());
        return accessor.getSchemaProperties(headers.getSchemaId(), schemaFormat, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasQueryIdByContentResponse response, SchemaFormat fallbackFormat) {
        SchemasQueryIdByContentHeaders headers = (SchemasQueryIdByContentHeaders)response.getDeserializedHeaders();
        SchemaFormat responseFormat = SchemaRegistryHelper.getSchemaFormat(response.getHeaders());
        SchemaFormat schemaFormat = responseFormat != null ? responseFormat : fallbackFormat;
        return accessor.getSchemaProperties(headers.getSchemaId(), schemaFormat, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasGetSchemaVersionResponse response) {
        SchemasGetSchemaVersionHeaders headers = (SchemasGetSchemaVersionHeaders)response.getDeserializedHeaders();
        SchemaFormat schemaFormat = SchemaRegistryHelper.getSchemaFormat(response.getHeaders());
        return accessor.getSchemaProperties(headers.getSchemaId(), schemaFormat, headers.getSchemaGroupName(), headers.getSchemaName(), headers.getSchemaVersion());
    }

    public static SchemaFormatImpl getContentType(SchemaFormat schemaFormat) {
        Objects.requireNonNull(schemaFormat, "'schemaFormat' cannot be null.'");
        if (schemaFormat == SchemaFormat.AVRO) {
            return SchemaFormatImpl.APPLICATION_JSON_SERIALIZATION_AVRO;
        }
        if (schemaFormat == SchemaFormat.JSON) {
            return SchemaFormatImpl.APPLICATION_JSON_SERIALIZATION_JSON;
        }
        return SchemaFormatImpl.TEXT_PLAIN_CHARSET_UTF8;
    }

    public static SchemaFormat getSchemaFormat(HttpHeaders headers) {
        String contentType = headers.getValue("Content-Type");
        if (contentType == null) {
            return null;
        }
        String replaced = SCHEMA_FORMAT_PATTERN.matcher(contentType).replaceAll("").toLowerCase(Locale.ROOT);
        SchemaFormatImpl implementationFormat = SCHEMA_FORMAT_HASH_MAP.getOrDefault(replaced, SchemaFormatImpl.TEXT_PLAIN_CHARSET_UTF8);
        if (SchemaFormatImpl.APPLICATION_JSON_SERIALIZATION_AVRO.equals((Object)implementationFormat)) {
            return SchemaFormat.AVRO;
        }
        if (SchemaFormatImpl.APPLICATION_JSON_SERIALIZATION_JSON.equals((Object)implementationFormat)) {
            return SchemaFormat.JSON;
        }
        return SchemaFormat.CUSTOM;
    }

    static {
        SchemaFormatImpl.values().forEach(value -> {
            String mimeTypeLower = value.toString().replaceAll("\\s", "").toLowerCase(Locale.ROOT);
            SCHEMA_FORMAT_HASH_MAP.put(mimeTypeLower, (SchemaFormatImpl)((Object)value));
        });
    }

    public static interface SchemaRegistryModelsAccessor {
        public SchemaProperties getSchemaProperties(String var1, SchemaFormat var2, String var3, String var4, int var5);
    }
}

