/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.ServiceVersion;
import com.azure.core.util.builder.ClientBuilderUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.SchemaRegistryClient;
import com.azure.data.schemaregistry.SchemaRegistryJsonSerializer;
import com.azure.data.schemaregistry.SchemaRegistryVersion;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImpl;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImplBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={SchemaRegistryAsyncClient.class, SchemaRegistryClient.class})
public class SchemaRegistryClientBuilder
implements ConfigurationTrait<SchemaRegistryClientBuilder>,
HttpTrait<SchemaRegistryClientBuilder>,
TokenCredentialTrait<SchemaRegistryClientBuilder> {
    private final ClientLogger logger = new ClientLogger(SchemaRegistryClientBuilder.class);
    private static final String DEFAULT_SCOPE = "https://eventhubs.azure.net/.default";
    private static final String CLIENT_PROPERTIES = "azure-data-schemaregistry.properties";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final RetryPolicy DEFAULT_RETRY_POLICY = new RetryPolicy("retry-after-ms", ChronoUnit.MILLIS);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private final String clientName;
    private final String clientVersion;
    private String fullyQualifiedNamespace;
    private HttpClient httpClient = null;
    private TokenCredential credential = null;
    private ClientOptions clientOptions;
    private HttpLogOptions httpLogOptions = new HttpLogOptions();
    private HttpPipeline httpPipeline;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private Configuration configuration;
    private ServiceVersion serviceVersion;

    public SchemaRegistryClientBuilder() {
        Map properties = CoreUtils.getProperties((String)CLIENT_PROPERTIES);
        this.clientName = properties.getOrDefault(NAME, "UnknownName");
        this.clientVersion = properties.getOrDefault(VERSION, "UnknownVersion");
    }

    public SchemaRegistryClientBuilder fullyQualifiedNamespace(String fullyQualifiedNamespace) {
        Objects.requireNonNull(fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null.");
        try {
            URL url = new URL(fullyQualifiedNamespace);
            this.fullyQualifiedNamespace = url.getHost();
        }
        catch (MalformedURLException ex) {
            this.logger.verbose("Fully qualified namespace did not contain protocol.");
            this.fullyQualifiedNamespace = fullyQualifiedNamespace;
        }
        return this;
    }

    public SchemaRegistryClientBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public SchemaRegistryClientBuilder pipeline(HttpPipeline httpPipeline) {
        if (this.httpPipeline != null && httpPipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = httpPipeline;
        return this;
    }

    public SchemaRegistryClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public SchemaRegistryClientBuilder credential(TokenCredential credential) {
        this.credential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public SchemaRegistryClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public SchemaRegistryClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public SchemaRegistryClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public SchemaRegistryClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public SchemaRegistryClientBuilder serviceVersion(ServiceVersion serviceVersion) {
        this.serviceVersion = serviceVersion;
        return this;
    }

    public SchemaRegistryClientBuilder addPolicy(HttpPipelinePolicy policy) {
        Objects.requireNonNull(policy, "'policy' cannot be null.");
        if (policy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(policy);
        } else {
            this.perRetryPolicies.add(policy);
        }
        return this;
    }

    public SchemaRegistryAsyncClient buildAsyncClient() {
        AzureSchemaRegistryImpl restService = this.getAzureSchemaRegistryImplService();
        return new SchemaRegistryAsyncClient(restService);
    }

    private AzureSchemaRegistryImpl getAzureSchemaRegistryImplService() {
        Objects.requireNonNull(this.credential, "'credential' cannot be null and must be set via builder.credential(TokenCredential)");
        Objects.requireNonNull(this.fullyQualifiedNamespace, "'fullyQualifiedNamespace' cannot be null and must be set via builder.fullyQualifiedNamespace(String)");
        if (CoreUtils.isNullOrEmpty((CharSequence)this.fullyQualifiedNamespace)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'fullyQualifiedNamespace' cannot be an empty string."));
        }
        Configuration buildConfiguration = this.configuration == null ? Configuration.getGlobalConfiguration() : this.configuration;
        HttpPipeline buildPipeline = this.httpPipeline;
        if (buildPipeline == null) {
            ArrayList<Object> policies = new ArrayList<Object>();
            policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)this.clientOptions, (HttpLogOptions)this.httpLogOptions), this.clientName, this.clientVersion, buildConfiguration));
            policies.add(new RequestIdPolicy());
            policies.add(new AddHeadersFromContextPolicy());
            policies.addAll(this.perCallPolicies);
            HttpPolicyProviders.addBeforeRetryPolicies(policies);
            policies.add(ClientBuilderUtil.validateAndGetRetryPolicy((HttpPipelinePolicy)this.retryPolicy, (RetryOptions)this.retryOptions, (HttpPipelinePolicy)DEFAULT_RETRY_POLICY));
            policies.add(new AddDatePolicy());
            policies.add(new BearerTokenAuthenticationPolicy(this.credential, new String[]{DEFAULT_SCOPE}));
            policies.addAll(this.perRetryPolicies);
            if (this.clientOptions != null) {
                ArrayList clientOptionsHeaders = new ArrayList();
                this.clientOptions.getHeaders().forEach(header -> clientOptionsHeaders.add(new HttpHeader(header.getName(), header.getValue())));
                if (!CoreUtils.isNullOrEmpty(clientOptionsHeaders)) {
                    policies.add(new AddHeadersPolicy(new HttpHeaders(clientOptionsHeaders)));
                }
            }
            HttpPolicyProviders.addAfterRetryPolicies(policies);
            policies.add(new HttpLoggingPolicy(this.httpLogOptions));
            buildPipeline = new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(this.httpClient).clientOptions(this.clientOptions).build();
        }
        SchemaRegistryVersion version = this.serviceVersion == null ? SchemaRegistryVersion.getLatest() : this.serviceVersion;
        SchemaRegistryJsonSerializer serializerAdapter = new SchemaRegistryJsonSerializer();
        AzureSchemaRegistryImpl restService = new AzureSchemaRegistryImplBuilder().serializerAdapter(serializerAdapter).endpoint(this.fullyQualifiedNamespace).apiVersion(version.getVersion()).pipeline(buildPipeline).buildClient();
        return restService;
    }

    public SchemaRegistryClient buildClient() {
        AzureSchemaRegistryImpl restService = this.getAzureSchemaRegistryImplService();
        return new SchemaRegistryClient(restService);
    }
}

