/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemaFormat;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterHeaders;
import com.azure.data.schemaregistry.models.SchemaProperties;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;

public final class SchemaRegistryHelper {
    private static final HashMap<String, SchemaFormat> SCHEMA_FORMAT_HASH_MAP = new HashMap();
    private static final Pattern SCHEMA_FORMAT_PATTERN = Pattern.compile("\\s");
    private static SchemaRegistryModelsAccessor accessor;

    public static void setAccessor(SchemaRegistryModelsAccessor modelsAccessor) {
        accessor = Objects.requireNonNull(modelsAccessor, "'modelsAccessor' cannot be null.");
    }

    public static SchemaProperties getSchemaProperties(SchemasRegisterHeaders deserializedHeaders, HttpHeaders httpHeaders, com.azure.data.schemaregistry.models.SchemaFormat fallbackFormat) {
        com.azure.data.schemaregistry.models.SchemaFormat responseFormat = SchemaRegistryHelper.getSchemaFormat(httpHeaders);
        com.azure.data.schemaregistry.models.SchemaFormat schemaFormat = responseFormat != null ? responseFormat : fallbackFormat;
        return accessor.getSchemaProperties(deserializedHeaders.getSchemaId(), schemaFormat, deserializedHeaders.getSchemaGroupName(), deserializedHeaders.getSchemaName(), deserializedHeaders.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasQueryIdByContentHeaders deserializedHeaders, HttpHeaders httpHeaders, com.azure.data.schemaregistry.models.SchemaFormat format) {
        com.azure.data.schemaregistry.models.SchemaFormat responseFormat = SchemaRegistryHelper.getSchemaFormat(httpHeaders);
        com.azure.data.schemaregistry.models.SchemaFormat schemaFormat = responseFormat != null ? responseFormat : format;
        return accessor.getSchemaProperties(deserializedHeaders.getSchemaId(), schemaFormat, deserializedHeaders.getSchemaGroupName(), deserializedHeaders.getSchemaName(), deserializedHeaders.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasGetByIdHeaders deserializedHeaders, HttpHeaders httpHeaders) {
        com.azure.data.schemaregistry.models.SchemaFormat schemaFormat = SchemaRegistryHelper.getSchemaFormat(httpHeaders);
        return accessor.getSchemaProperties(deserializedHeaders.getSchemaId(), schemaFormat, deserializedHeaders.getSchemaGroupName(), deserializedHeaders.getSchemaName(), deserializedHeaders.getSchemaVersion());
    }

    public static SchemaProperties getSchemaProperties(SchemasGetSchemaVersionHeaders deserializedHeaders, HttpHeaders httpHeaders) {
        com.azure.data.schemaregistry.models.SchemaFormat schemaFormat = SchemaRegistryHelper.getSchemaFormat(httpHeaders);
        return accessor.getSchemaProperties(deserializedHeaders.getSchemaId(), schemaFormat, deserializedHeaders.getSchemaGroupName(), deserializedHeaders.getSchemaName(), deserializedHeaders.getSchemaVersion());
    }

    public static SchemaFormat getContentType(com.azure.data.schemaregistry.models.SchemaFormat schemaFormat) {
        Objects.requireNonNull(schemaFormat, "'schemaFormat' cannot be null.'");
        if (schemaFormat == com.azure.data.schemaregistry.models.SchemaFormat.AVRO) {
            return SchemaFormat.APPLICATION_JSON_SERIALIZATION_AVRO;
        }
        if (schemaFormat == com.azure.data.schemaregistry.models.SchemaFormat.JSON) {
            return SchemaFormat.APPLICATION_JSON_SERIALIZATION_JSON;
        }
        return SchemaFormat.TEXT_PLAIN_CHARSET_UTF8;
    }

    public static com.azure.data.schemaregistry.models.SchemaFormat getSchemaFormat(HttpHeaders headers) {
        String contentType = headers.getValue(HttpHeaderName.CONTENT_TYPE);
        if (contentType == null) {
            return null;
        }
        String replaced = SCHEMA_FORMAT_PATTERN.matcher(contentType).replaceAll("").toLowerCase(Locale.ROOT);
        SchemaFormat implementationFormat = SCHEMA_FORMAT_HASH_MAP.getOrDefault(replaced, SchemaFormat.TEXT_PLAIN_CHARSET_UTF8);
        if (SchemaFormat.APPLICATION_JSON_SERIALIZATION_AVRO.equals((Object)implementationFormat)) {
            return com.azure.data.schemaregistry.models.SchemaFormat.AVRO;
        }
        if (SchemaFormat.APPLICATION_JSON_SERIALIZATION_JSON.equals((Object)implementationFormat)) {
            return com.azure.data.schemaregistry.models.SchemaFormat.JSON;
        }
        return com.azure.data.schemaregistry.models.SchemaFormat.CUSTOM;
    }

    static {
        SchemaFormat.values().forEach(value -> {
            String mimeTypeLower = SCHEMA_FORMAT_PATTERN.matcher(value.toString()).replaceAll("").toLowerCase(Locale.ROOT);
            SCHEMA_FORMAT_HASH_MAP.put(mimeTypeLower, (SchemaFormat)((Object)value));
        });
    }

    public static interface SchemaRegistryModelsAccessor {
        public SchemaProperties getSchemaProperties(String var1, com.azure.data.schemaregistry.models.SchemaFormat var2, String var3, String var4, int var5);
    }
}

