/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.schemaregistry.SchemaRegistryAsyncClient;
import com.azure.data.schemaregistry.SchemaRegistryClientBuilder;
import com.azure.data.schemaregistry.implementation.AzureSchemaRegistryImpl;
import com.azure.data.schemaregistry.implementation.SchemaRegistryHelper;
import com.azure.data.schemaregistry.implementation.models.ErrorException;
import com.azure.data.schemaregistry.implementation.models.SchemaFormat;
import com.azure.data.schemaregistry.implementation.models.SchemasGetByIdHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasGetSchemaVersionHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasQueryIdByContentHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemasRegisterHeaders;
import com.azure.data.schemaregistry.models.SchemaProperties;
import com.azure.data.schemaregistry.models.SchemaRegistrySchema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@ServiceClient(builder=SchemaRegistryClientBuilder.class)
public final class SchemaRegistryClient {
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private final ClientLogger logger = new ClientLogger(SchemaRegistryClient.class);
    private final AzureSchemaRegistryImpl restService;

    SchemaRegistryClient(AzureSchemaRegistryImpl restService) {
        this.restService = restService;
        new SchemaProperties("", com.azure.data.schemaregistry.models.SchemaFormat.AVRO);
    }

    public String getFullyQualifiedNamespace() {
        return this.restService.getEndpoint();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaProperties registerSchema(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format) {
        return (SchemaProperties)this.registerSchemaWithResponse(groupName, name, schemaDefinition, format, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaProperties> registerSchemaWithResponse(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format, Context context) {
        if (Objects.isNull(groupName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'groupName' should not be null."));
        }
        if (Objects.isNull(name)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'name' should not be null."));
        }
        if (Objects.isNull(schemaDefinition)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'schemaDefinition' should not be null."));
        }
        if (Objects.isNull((Object)format)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'format' should not be null."));
        }
        this.logger.verbose("Registering schema. Group: '{}', name: '{}', serialization type: '{}', payload: '{}'", new Object[]{groupName, name, format, schemaDefinition});
        BinaryData binaryData = BinaryData.fromString((String)schemaDefinition);
        SchemaFormat contentType = SchemaRegistryHelper.getContentType(format);
        ResponseBase<SchemasRegisterHeaders, Void> response = this.restService.getSchemas().registerWithResponse(groupName, name, contentType.toString(), binaryData, binaryData.getLength(), context);
        SchemaProperties registered = SchemaRegistryHelper.getSchemaProperties((SchemasRegisterHeaders)response.getDeserializedHeaders(), response.getHeaders(), format);
        return new SimpleResponse(response, (Object)registered);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaRegistrySchema getSchema(String schemaId) {
        return (SchemaRegistrySchema)this.getSchemaWithResponse(schemaId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaRegistrySchema getSchema(String groupName, String schemaName, int schemaVersion) {
        return (SchemaRegistrySchema)this.getSchemaWithResponse(groupName, schemaName, schemaVersion, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaRegistrySchema> getSchemaWithResponse(String schemaId, Context context) {
        if (Objects.isNull(schemaId)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'schemaId' should not be null."));
        }
        try {
            ResponseBase<SchemasGetByIdHeaders, BinaryData> response = this.restService.getSchemas().getByIdWithResponse(schemaId, context);
            SchemaProperties schemaObject = SchemaRegistryHelper.getSchemaProperties((SchemasGetByIdHeaders)response.getDeserializedHeaders(), response.getHeaders());
            return new SimpleResponse(response, (Object)new SchemaRegistrySchema(schemaObject, SchemaRegistryClient.convertToString(((BinaryData)response.getValue()).toStream())));
        }
        catch (ErrorException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)SchemaRegistryAsyncClient.remapError(ex));
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaRegistrySchema> getSchemaWithResponse(String groupName, String schemaName, int schemaVersion, Context context) {
        if (Objects.isNull(groupName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'groupName' should not be null."));
        }
        ResponseBase<SchemasGetSchemaVersionHeaders, BinaryData> response = this.restService.getSchemas().getSchemaVersionWithResponse(groupName, schemaName, schemaVersion, context);
        InputStream schemaInputStream = ((BinaryData)response.getValue()).toStream();
        SchemaProperties schemaObject = SchemaRegistryHelper.getSchemaProperties((SchemasGetSchemaVersionHeaders)response.getDeserializedHeaders(), response.getHeaders());
        if (schemaInputStream == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Schema definition should not be null. Group Name: %s. Schema Name: %s. Version: %d", groupName, schemaName, schemaVersion)));
        }
        return new SimpleResponse(response, (Object)new SchemaRegistrySchema(schemaObject, SchemaRegistryClient.convertToString(schemaInputStream)));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SchemaProperties getSchemaProperties(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format) {
        return (SchemaProperties)this.getSchemaPropertiesWithResponse(groupName, name, schemaDefinition, format, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SchemaProperties> getSchemaPropertiesWithResponse(String groupName, String name, String schemaDefinition, com.azure.data.schemaregistry.models.SchemaFormat format, Context context) {
        if (Objects.isNull(groupName)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'groupName' cannot be null."));
        }
        if (Objects.isNull(name)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'name' cannot be null."));
        }
        if (Objects.isNull(schemaDefinition)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'schemaDefinition' cannot be null."));
        }
        if (Objects.isNull((Object)format)) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'format' cannot be null."));
        }
        if (context == null) {
            context = Context.NONE;
        }
        BinaryData binaryData = BinaryData.fromString((String)schemaDefinition);
        SchemaFormat contentType = SchemaRegistryHelper.getContentType(format);
        try {
            ResponseBase<SchemasQueryIdByContentHeaders, Void> response = this.restService.getSchemas().queryIdByContentWithResponse(groupName, name, contentType, binaryData, binaryData.getLength(), context);
            SchemaProperties properties = SchemaRegistryHelper.getSchemaProperties((SchemasQueryIdByContentHeaders)response.getDeserializedHeaders(), response.getHeaders(), format);
            return new SimpleResponse(response, (Object)properties);
        }
        catch (ErrorException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)SchemaRegistryAsyncClient.remapError(ex));
        }
    }

    static String convertToString(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        try {
            int read;
            while ((read = inputStream.read(buffer, 0, buffer.length)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            return outputStream.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException exception) {
            throw new UncheckedIOException("Error occurred while deserializing schemaContent.", exception);
        }
    }
}

