/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.schemaregistry.implementation.models;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.data.schemaregistry.implementation.models.SchemaFormat;

public final class SchemasGetSchemaVersionHeaders {
    private Integer schemaVersion;
    private String schemaId;
    private String schemaGroupName;
    private String schemaName;
    private String schemaIdLocation;
    private String location;
    private SchemaFormat contentType;
    private static final HttpHeaderName SCHEMA_VERSION = HttpHeaderName.fromString((String)"Schema-Version");
    private static final HttpHeaderName SCHEMA_ID = HttpHeaderName.fromString((String)"Schema-Id");
    private static final HttpHeaderName SCHEMA_GROUP_NAME = HttpHeaderName.fromString((String)"Schema-Group-Name");
    private static final HttpHeaderName SCHEMA_NAME = HttpHeaderName.fromString((String)"Schema-Name");
    private static final HttpHeaderName SCHEMA_ID_LOCATION = HttpHeaderName.fromString((String)"Schema-Id-Location");

    public SchemasGetSchemaVersionHeaders(HttpHeaders rawHeaders) {
        String schemaVersion = rawHeaders.getValue(SCHEMA_VERSION);
        if (schemaVersion != null) {
            this.schemaVersion = Integer.parseInt(schemaVersion);
        }
        this.schemaId = rawHeaders.getValue(SCHEMA_ID);
        this.schemaGroupName = rawHeaders.getValue(SCHEMA_GROUP_NAME);
        this.schemaName = rawHeaders.getValue(SCHEMA_NAME);
        this.schemaIdLocation = rawHeaders.getValue(SCHEMA_ID_LOCATION);
        this.location = rawHeaders.getValue(HttpHeaderName.LOCATION);
        String contentType = rawHeaders.getValue(HttpHeaderName.CONTENT_TYPE);
        if (contentType != null) {
            this.contentType = SchemaFormat.fromString(contentType);
        }
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public SchemasGetSchemaVersionHeaders setSchemaVersion(Integer schemaVersion) {
        this.schemaVersion = schemaVersion;
        return this;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public SchemasGetSchemaVersionHeaders setSchemaId(String schemaId) {
        this.schemaId = schemaId;
        return this;
    }

    public String getSchemaGroupName() {
        return this.schemaGroupName;
    }

    public SchemasGetSchemaVersionHeaders setSchemaGroupName(String schemaGroupName) {
        this.schemaGroupName = schemaGroupName;
        return this;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public SchemasGetSchemaVersionHeaders setSchemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public String getSchemaIdLocation() {
        return this.schemaIdLocation;
    }

    public SchemasGetSchemaVersionHeaders setSchemaIdLocation(String schemaIdLocation) {
        this.schemaIdLocation = schemaIdLocation;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public SchemasGetSchemaVersionHeaders setLocation(String location) {
        this.location = location;
        return this;
    }

    public SchemaFormat getContentType() {
        return this.contentType;
    }

    public SchemasGetSchemaVersionHeaders setContentType(SchemaFormat contentType) {
        this.contentType = contentType;
        return this;
    }
}

