/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.AddDatePolicy;
import com.azure.core.http.policy.AddHeadersPolicy;
import com.azure.core.http.policy.AzureSasCredentialPolicy;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpLoggingPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPolicyProviders;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.TablesSharedKeyCredential;
import com.azure.data.tables.TablesSharedKeyCredentialPolicy;
import com.azure.data.tables.implementation.NullHttpClient;
import com.azure.storage.common.policy.RequestRetryOptions;
import com.azure.storage.common.policy.RequestRetryPolicy;
import com.azure.storage.common.policy.ResponseValidationPolicyBuilder;
import com.azure.storage.common.policy.ScrubEtagPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class BuilderHelper {
    private static final Map<String, String> PROPERTIES = CoreUtils.getProperties((String)"azure-data-tables.properties");
    private static final String CLIENT_NAME = PROPERTIES.getOrDefault("name", "UnknownName");
    private static final String CLIENT_VERSION = PROPERTIES.getOrDefault("version", "UnknownVersion");

    BuilderHelper() {
    }

    static HttpPipeline buildPipeline(TablesSharedKeyCredential tablesSharedKeyCredential, TokenCredential tokenCredential, AzureSasCredential azureSasCredential, String sasToken, String endpoint, RequestRetryOptions retryOptions, HttpLogOptions logOptions, ClientOptions clientOptions, HttpClient httpClient, List<HttpPipelinePolicy> perCallAdditionalPolicies, List<HttpPipelinePolicy> perRetryAdditionalPolicies, Configuration configuration, ClientLogger logger) {
        Object credentialPolicy;
        configuration = configuration == null ? Configuration.getGlobalConfiguration() : configuration;
        BuilderHelper.validateSingleCredentialIsPresent(tablesSharedKeyCredential, tokenCredential, azureSasCredential, sasToken, logger);
        ArrayList<Object> policies = new ArrayList<Object>();
        policies.add(new UserAgentPolicy(CoreUtils.getApplicationId((ClientOptions)clientOptions, (HttpLogOptions)logOptions), CLIENT_NAME, CLIENT_VERSION, configuration));
        policies.add(new RequestIdPolicy());
        ArrayList httpHeaderList = new ArrayList();
        if (clientOptions != null) {
            clientOptions.getHeaders().forEach(header -> httpHeaderList.add(new HttpHeader(header.getName(), header.getValue())));
        }
        policies.add(new AddHeadersPolicy(new HttpHeaders(httpHeaderList).set("Accept", "application/json")));
        policies.addAll(perCallAdditionalPolicies);
        HttpPolicyProviders.addBeforeRetryPolicies(policies);
        policies.add(new RequestRetryPolicy(retryOptions));
        policies.add(new AddDatePolicy());
        if (tablesSharedKeyCredential != null) {
            credentialPolicy = new TablesSharedKeyCredentialPolicy(tablesSharedKeyCredential);
        } else if (tokenCredential != null) {
            UrlBuilder endpointParts = UrlBuilder.parse((String)endpoint);
            if (!endpointParts.getScheme().equals("https")) {
                throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("HTTPS is required when using a %s credential.", tokenCredential.getClass().getName())));
            }
            credentialPolicy = new BearerTokenAuthenticationPolicy(tokenCredential, new String[]{BuilderHelper.getBearerTokenScope(endpointParts)});
        } else {
            credentialPolicy = azureSasCredential != null ? new AzureSasCredentialPolicy(azureSasCredential, false) : (sasToken != null ? new AzureSasCredentialPolicy(new AzureSasCredential(sasToken), false) : null);
        }
        if (credentialPolicy != null) {
            policies.add(credentialPolicy);
        }
        policies.addAll(perRetryAdditionalPolicies);
        HttpPolicyProviders.addAfterRetryPolicies(policies);
        policies.add(BuilderHelper.getResponseValidationPolicy());
        policies.add(new HttpLoggingPolicy(logOptions));
        policies.add(new ScrubEtagPolicy());
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).httpClient(httpClient).build();
    }

    static HttpPipeline buildNullClientPipeline() {
        HttpPipelinePolicy[] policies = new HttpPipelinePolicy[]{new AddHeadersPolicy(new HttpHeaders().put("Accept", "application/json;odata=minimalmetadata"))};
        return new HttpPipelineBuilder().policies(policies).httpClient((HttpClient)new NullHttpClient()).build();
    }

    private static void validateSingleCredentialIsPresent(TablesSharedKeyCredential storageSharedKeyCredential, TokenCredential tokenCredential, AzureSasCredential azureSasCredential, String sasToken, ClientLogger logger) {
        List usedCredentials = Stream.of(storageSharedKeyCredential, tokenCredential, azureSasCredential, sasToken).filter(Objects::nonNull).collect(Collectors.toList());
        if (usedCredentials.size() > 1) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalStateException("Only one credential should be used. Credentials present: " + usedCredentials.stream().map(c -> c instanceof String ? "sasToken" : c.getClass().getName()).collect(Collectors.joining(","))));
        }
    }

    private static String getBearerTokenScope(UrlBuilder endpoint) {
        CharSequence[] hostParts = endpoint.getHost().split("\\.");
        if (hostParts[0].endsWith("-secondary")) {
            hostParts[0] = hostParts[0].substring(0, hostParts[0].length() - 10);
            endpoint.setHost(String.join((CharSequence)".", hostParts));
        }
        return String.format("%s/.default", endpoint.toString());
    }

    private static HttpPipelinePolicy getResponseValidationPolicy() {
        return new ResponseValidationPolicyBuilder().addOptionalEcho("x-ms-client-request-id").addOptionalEcho("x-ms-encryption-key-sha256").build();
    }
}

