/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.models.TableEntity;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;

final class EntityHelper {
    private static final HashSet<String> TABLE_ENTITY_METHODS = Arrays.stream(TableEntity.class.getMethods()).map(Method::getName).collect(Collectors.toCollection(HashSet::new));

    private EntityHelper() {
    }

    static void setPropertiesFromGetters(TableEntity entity, ClientLogger logger) {
        Class<?> myClass = entity.getClass();
        if (myClass == TableEntity.class) {
            return;
        }
        for (Method m : myClass.getMethods()) {
            if (m.getName().length() < 3 || TABLE_ENTITY_METHODS.contains(m.getName()) || !m.getName().startsWith("get") && !m.getName().startsWith("is") || m.getParameterTypes().length != 0 || Void.TYPE.equals(m.getReturnType()) || m.getName().startsWith("is") && m.getReturnType() != Boolean.class && m.getReturnType() != Boolean.TYPE) continue;
            int prefixLength = m.getName().startsWith("is") ? 2 : 3;
            String propName = m.getName().substring(prefixLength);
            try {
                entity.getProperties().put(propName, m.invoke((Object)entity, new Object[0]));
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                logger.logThrowableAsWarning((Throwable)new ReflectiveOperationException(String.format("Failed to get property '%s' on type '%s'", propName, myClass.getName()), e));
            }
        }
    }

    static <T extends TableEntity> T convertToSubclass(TableEntity entity, Class<T> clazz, ClientLogger logger) {
        TableEntity result;
        if (TableEntity.class == clazz) {
            return (T)entity;
        }
        try {
            result = (TableEntity)clazz.getDeclaredConstructor(String.class, String.class).newInstance(entity.getPartitionKey(), entity.getRowKey());
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("Failed to instantiate type '%s'. It must contain a constructor that accepts two arguments: the partition key and row key.", clazz.getName()), e));
        }
        result.addProperties(entity.getProperties());
        for (Method m : clazz.getMethods()) {
            if (m.getName().length() < 4 || !m.getName().startsWith("set") || m.getParameterTypes().length != 1 || !Void.TYPE.equals(m.getReturnType())) continue;
            String propName = m.getName().substring(3);
            Object value = result.getProperties().get(propName);
            if (value == null) continue;
            Class<?> paramType = m.getParameterTypes()[0];
            if (paramType.isEnum() && value instanceof String) {
                try {
                    value = Enum.valueOf(paramType.asSubclass(Enum.class), (String)value);
                }
                catch (IllegalArgumentException e) {
                    logger.logThrowableAsWarning((Throwable)new IllegalArgumentException(String.format("Failed to convert '%s' to value of enum '%s'", propName, paramType.getName()), e));
                    continue;
                }
            }
            try {
                m.invoke((Object)result, value);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                logger.logThrowableAsWarning((Throwable)new ReflectiveOperationException(String.format("Failed to set property '%s' on type '%s'", propName, clazz.getName()), e));
            }
        }
        return (T)result;
    }
}

