/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.BuilderHelper;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.TableClientBuilder;
import com.azure.data.tables.implementation.BatchImpl;
import com.azure.data.tables.implementation.ModelHelper;
import com.azure.data.tables.implementation.TablesMultipartSerializer;
import com.azure.data.tables.implementation.models.BatchChangeSet;
import com.azure.data.tables.implementation.models.BatchOperation;
import com.azure.data.tables.implementation.models.BatchRequestBody;
import com.azure.data.tables.implementation.models.BatchSubRequest;
import com.azure.data.tables.implementation.models.BatchSubmitBatchResponse;
import com.azure.data.tables.implementation.models.TableServiceError;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.models.BatchOperationResponse;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.UpdateMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TableAsyncBatch {
    private static final TablesMultipartSerializer BATCH_SERIALIZER = new TablesMultipartSerializer();
    private final ClientLogger logger = new ClientLogger(TableAsyncBatch.class);
    private final String partitionKey;
    private final TableAsyncClient operationClient;
    private final BatchImpl batchImpl;
    private final HashSet<String> rowKeys = new HashSet();
    private final List<BatchOperation> operations = new ArrayList<BatchOperation>();
    private boolean frozen = false;

    TableAsyncBatch(String partitionKey, TableAsyncClient client) {
        this.partitionKey = partitionKey;
        this.batchImpl = new BatchImpl(client.getImplementation(), (SerializerAdapter)BATCH_SERIALIZER);
        this.operationClient = new TableClientBuilder().tableName(client.getTableName()).endpoint(client.getImplementation().getUrl()).serviceVersion(client.getApiVersion()).pipeline(BuilderHelper.buildNullClientPipeline()).buildAsyncClient();
    }

    public TableAsyncBatch createEntity(TableEntity entity) {
        this.validate(entity);
        this.addOperation(new BatchOperation.CreateEntity(entity));
        return this;
    }

    public TableAsyncBatch upsertEntity(TableEntity entity) {
        return this.upsertEntity(entity, UpdateMode.MERGE);
    }

    public TableAsyncBatch upsertEntity(TableEntity entity, UpdateMode updateMode) {
        this.validate(entity);
        this.addOperation(new BatchOperation.UpsertEntity(entity, updateMode));
        return this;
    }

    public TableAsyncBatch updateEntity(TableEntity entity) {
        return this.updateEntity(entity, UpdateMode.MERGE);
    }

    public TableAsyncBatch updateEntity(TableEntity entity, UpdateMode updateMode) {
        return this.updateEntity(entity, updateMode, false);
    }

    public TableAsyncBatch updateEntity(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged) {
        this.validate(entity);
        this.addOperation(new BatchOperation.UpdateEntity(entity, updateMode, ifUnchanged));
        return this;
    }

    public TableAsyncBatch deleteEntity(String rowKey) {
        return this.deleteEntity(rowKey, "*");
    }

    public TableAsyncBatch deleteEntity(String rowKey, String eTag) {
        this.validate(this.partitionKey, rowKey);
        this.addOperation(new BatchOperation.DeleteEntity(this.partitionKey, rowKey, eTag));
        return this;
    }

    public synchronized List<BatchOperation> getOperations() {
        return Collections.unmodifiableList(this.operations);
    }

    public synchronized Mono<List<BatchOperationResponse>> submitTransaction() {
        return this.submitTransactionWithResponse().flatMap(response -> Mono.justOrEmpty((Object)((List)response.getValue())));
    }

    public synchronized Mono<Response<List<BatchOperationResponse>>> submitTransactionWithResponse() {
        return FluxUtil.withContext(this::submitTransactionWithResponse);
    }

    synchronized Mono<Response<List<BatchOperationResponse>>> submitTransactionWithResponse(Context context) {
        Context finalContext;
        this.frozen = true;
        Context context2 = finalContext = context == null ? Context.NONE : context;
        if (this.operations.size() == 0) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("A batch must contain at least one operation."));
        }
        return Flux.fromIterable(this.operations).flatMapSequential(op -> op.prepareRequest(this.operationClient).zipWith(Mono.just((Object)op))).collect(BatchRequestBody::new, (body, pair) -> body.addChangeOperation(new BatchSubRequest((BatchOperation)pair.getT2(), (HttpRequest)pair.getT1()))).flatMap(body -> this.batchImpl.submitBatchWithRestResponseAsync((BatchRequestBody)body, null, finalContext).zipWith(Mono.just((Object)body))).flatMap(pair -> this.parseResponse((BatchRequestBody)pair.getT2(), (BatchSubmitBatchResponse)((Object)((Object)pair.getT1()))));
    }

    private Mono<Response<List<BatchOperationResponse>>> parseResponse(BatchRequestBody requestBody, BatchSubmitBatchResponse response) {
        TableServiceError error = null;
        String errorMessage = null;
        BatchChangeSet changes = null;
        Object failedOperation = null;
        if (requestBody.getContents().get(0) instanceof BatchChangeSet) {
            changes = (BatchChangeSet)requestBody.getContents().get(0);
        }
        for (int i = 0; i < response.getValue().length; ++i) {
            BatchOperationResponse subResponse = response.getValue()[i];
            if (changes != null && changes.getContents().get(i) != null) {
                ModelHelper.updateBatchOperationResponse(subResponse, ((BatchSubRequest)changes.getContents().get(i)).getHttpRequest());
            }
            if (subResponse.getStatusCode() < 400 || error != null || errorMessage != null) continue;
            if (subResponse.getValue() instanceof TableServiceError) {
                error = (TableServiceError)subResponse.getValue();
                if (changes == null || error.getOdataError() == null || error.getOdataError().getMessage() == null || error.getOdataError().getMessage().getValue() == null) continue;
                String message = error.getOdataError().getMessage().getValue();
                try {
                    int failedIndex = Integer.parseInt(message.substring(0, message.indexOf(":")));
                    failedOperation = ((BatchSubRequest)changes.getContents().get(failedIndex)).getOperation();
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            errorMessage = subResponse.getValue() instanceof String ? "The service returned the following data for the failed operation: " + subResponse.getValue() : "The service returned the following status code for the failed operation: " + subResponse.getStatusCode();
        }
        if (error != null || errorMessage != null) {
            String message = "An operation within the batch failed, the transaction has been rolled back.";
            if (failedOperation != null) {
                message = message + " The failed operation was: " + failedOperation.toString();
            } else if (errorMessage != null) {
                message = message + " " + errorMessage;
            }
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)((Object)new TableServiceErrorException(message, null, error)));
        }
        return Mono.just((Object)new SimpleResponse((Response)response, Arrays.asList(response.getValue())));
    }

    private synchronized void addOperation(BatchOperation operation) {
        this.operations.add(operation);
    }

    private synchronized void validate(TableEntity entity) {
        this.validate(entity.getPartitionKey(), entity.getRowKey());
    }

    private synchronized void validate(String partitionKey, String rowKey) {
        if (this.frozen) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Operations can't be modified once a batch is submitted."));
        }
        if (!this.partitionKey.equals(partitionKey)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("All operations in a batch must share the same partition key."));
        }
        if (CoreUtils.isNullOrEmpty((CharSequence)rowKey)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The row key must not be null or empty."));
        }
        if (this.rowKeys.contains(rowKey)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Every operation in a batch must use a different row key."));
        }
        this.rowKeys.add(rowKey);
    }
}

