/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.EntityHelper;
import com.azure.data.tables.TableAsyncBatch;
import com.azure.data.tables.TablesServiceVersion;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.AzureTableImplBuilder;
import com.azure.data.tables.implementation.ModelHelper;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.TableEntityQueryResponse;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TablesQueryEntitiesHeaders;
import com.azure.data.tables.models.ListEntitiesOptions;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.UpdateMode;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public final class TableAsyncClient {
    private static final String DELIMITER_CONTINUATION_TOKEN = ";";
    private final ClientLogger logger = new ClientLogger(TableAsyncClient.class);
    private final String tableName;
    private final AzureTableImpl implementation;
    private final SerializerAdapter serializerAdapter;
    private final String accountName;
    private final String tableUrl;
    private final HttpPipeline pipeline;

    private TableAsyncClient(String tableName, AzureTableImpl implementation, SerializerAdapter serializerAdapter) {
        this.serializerAdapter = serializerAdapter;
        try {
            if (tableName == null || tableName.isEmpty()) {
                throw new IllegalArgumentException("'tableName' must be provided to create a TableClient");
            }
            URI uri = URI.create(implementation.getUrl());
            this.accountName = uri.getHost().split("\\.", 2)[0];
            this.tableUrl = uri.resolve("/" + tableName).toString();
            this.logger.verbose("Table Service URI: {}", new Object[]{uri});
        }
        catch (IllegalArgumentException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)ex);
        }
        this.implementation = implementation;
        this.tableName = tableName;
        this.pipeline = implementation.getHttpPipeline();
    }

    TableAsyncClient(String tableName, HttpPipeline pipeline, String serviceUrl, TablesServiceVersion serviceVersion, SerializerAdapter serializerAdapter) {
        this(tableName, new AzureTableImplBuilder().url(serviceUrl).serializerAdapter(serializerAdapter).pipeline(pipeline).version(serviceVersion.getVersion()).buildClient(), serializerAdapter);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getTableUrl() {
        return this.tableUrl;
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    public TablesServiceVersion getApiVersion() {
        return TablesServiceVersion.fromString(this.implementation.getVersion());
    }

    public TableAsyncBatch createBatch(String partitionKey) {
        if (CoreUtils.isNullOrEmpty((CharSequence)partitionKey)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("The partition key must not be null or empty."));
        }
        return new TableAsyncBatch(partitionKey, this);
    }

    AzureTableImpl getImplementation() {
        return this.implementation;
    }

    public Mono<Void> create() {
        return this.createWithResponse().flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> createWithResponse() {
        return FluxUtil.withContext(context -> this.createWithResponse((Context)context));
    }

    Mono<Response<Void>> createWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        TableProperties properties = new TableProperties().setTableName(this.tableName);
        try {
            return this.implementation.getTables().createWithResponseAsync(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context).map(response -> new SimpleResponse((Response)response, null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> createEntity(TableEntity entity) {
        return this.createEntityWithResponse(entity).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> createEntityWithResponse(TableEntity entity) {
        return FluxUtil.withContext(context -> this.createEntityWithResponse(entity, null, (Context)context));
    }

    Mono<Response<Void>> createEntityWithResponse(TableEntity entity, Duration timeout, Context context) {
        Integer timeoutInt;
        context = context == null ? Context.NONE : context;
        Integer n = timeoutInt = timeout == null ? null : Integer.valueOf((int)timeout.getSeconds());
        if (entity == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("TableEntity cannot be null"));
        }
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        return this.implementation.getTables().insertEntityWithResponseAsync(this.tableName, timeoutInt, null, ResponseFormat.RETURN_NO_CONTENT, entity.getProperties(), null, context).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
    }

    public Mono<Void> upsertEntity(TableEntity entity) {
        return this.upsertEntityWithResponse(entity, null).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Void> upsertEntity(TableEntity entity, UpdateMode updateMode) {
        return this.upsertEntityWithResponse(entity, updateMode).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> upsertEntityWithResponse(TableEntity entity, UpdateMode updateMode) {
        return FluxUtil.withContext(context -> this.upsertEntityWithResponse(entity, updateMode, null, (Context)context));
    }

    Mono<Response<Void>> upsertEntityWithResponse(TableEntity entity, UpdateMode updateMode, Duration timeout, Context context) {
        Integer timeoutInt;
        context = context == null ? Context.NONE : context;
        Integer n = timeoutInt = timeout == null ? null : Integer.valueOf((int)timeout.getSeconds());
        if (entity == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("TableEntity cannot be null"));
        }
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        if (updateMode == UpdateMode.REPLACE) {
            return this.implementation.getTables().updateEntityWithResponseAsync(this.tableName, entity.getPartitionKey(), entity.getRowKey(), timeoutInt, null, null, entity.getProperties(), null, context).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        return this.implementation.getTables().mergeEntityWithResponseAsync(this.tableName, entity.getPartitionKey(), entity.getRowKey(), timeoutInt, null, null, entity.getProperties(), null, context).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
    }

    public Mono<Void> updateEntity(TableEntity entity) {
        return this.updateEntity(entity, null);
    }

    public Mono<Void> updateEntity(TableEntity entity, UpdateMode updateMode) {
        return this.updateEntity(entity, updateMode, false);
    }

    public Mono<Void> updateEntity(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged) {
        return this.updateEntityWithResponse(entity, updateMode, ifUnchanged).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> updateEntityWithResponse(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged) {
        return FluxUtil.withContext(context -> this.updateEntityWithResponse(entity, updateMode, ifUnchanged, null, (Context)context));
    }

    Mono<Response<Void>> updateEntityWithResponse(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged, Duration timeout, Context context) {
        Integer timeoutInt;
        context = context == null ? Context.NONE : context;
        Integer n = timeoutInt = timeout == null ? null : Integer.valueOf((int)timeout.getSeconds());
        if (entity == null) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new NullPointerException("TableEntity cannot be null"));
        }
        String eTag = ifUnchanged ? entity.getETag() : "*";
        EntityHelper.setPropertiesFromGetters(entity, this.logger);
        if (updateMode == UpdateMode.REPLACE) {
            return this.implementation.getTables().updateEntityWithResponseAsync(this.tableName, entity.getPartitionKey(), entity.getRowKey(), timeoutInt, null, eTag, entity.getProperties(), null, context).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        }
        return this.implementation.getTables().mergeEntityWithResponseAsync(this.tableName, entity.getPartitionKey(), entity.getRowKey(), timeoutInt, null, eTag, entity.getProperties(), null, context).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
    }

    public Mono<Void> delete() {
        return this.deleteWithResponse().flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> deleteWithResponse() {
        return FluxUtil.withContext(context -> this.deleteWithResponse((Context)context));
    }

    Mono<Response<Void>> deleteWithResponse(Context context) {
        context = context == null ? Context.NONE : context;
        return this.implementation.getTables().deleteWithResponseAsync(this.tableName, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public Mono<Void> deleteEntity(String partitionKey, String rowKey) {
        return this.deleteEntity(partitionKey, rowKey, null);
    }

    public Mono<Void> deleteEntity(String partitionKey, String rowKey, String eTag) {
        return this.deleteEntityWithResponse(partitionKey, rowKey, eTag).then();
    }

    public Mono<Response<Void>> deleteEntityWithResponse(String partitionKey, String rowKey, String eTag) {
        return FluxUtil.withContext(context -> this.deleteEntityWithResponse(partitionKey, rowKey, eTag, null, (Context)context));
    }

    Mono<Response<Void>> deleteEntityWithResponse(String partitionKey, String rowKey, String eTag, Duration timeout, Context context) {
        context = context == null ? Context.NONE : context;
        String matchParam = eTag == null ? "*" : eTag;
        Integer timeoutInt = timeout == null ? null : Integer.valueOf((int)timeout.getSeconds());
        context = context == null ? Context.NONE : context;
        return this.implementation.getTables().deleteEntityWithResponseAsync(this.tableName, partitionKey, rowKey, matchParam, timeoutInt, null, null, context).map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
    }

    public PagedFlux<TableEntity> listEntities() {
        return this.listEntities(new ListEntitiesOptions());
    }

    public PagedFlux<TableEntity> listEntities(ListEntitiesOptions options) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listEntitiesFirstPage((Context)context, options, (Class)TableEntity.class)), token -> FluxUtil.withContext(context -> this.listEntitiesNextPage((String)token, (Context)context, options, (Class)TableEntity.class)));
    }

    public <T extends TableEntity> PagedFlux<T> listEntities(Class<T> resultType) {
        return this.listEntities(new ListEntitiesOptions(), resultType);
    }

    public <T extends TableEntity> PagedFlux<T> listEntities(ListEntitiesOptions options, Class<T> resultType) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listEntitiesFirstPage((Context)context, options, resultType)), token -> FluxUtil.withContext(context -> this.listEntitiesNextPage((String)token, (Context)context, options, resultType)));
    }

    private <T extends TableEntity> Mono<PagedResponse<T>> listEntitiesFirstPage(Context context, ListEntitiesOptions options, Class<T> resultType) {
        try {
            return this.listEntities(null, null, context, options, resultType);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private <T extends TableEntity> Mono<PagedResponse<T>> listEntitiesNextPage(String token, Context context, ListEntitiesOptions options, Class<T> resultType) {
        if (token == null) {
            return Mono.empty();
        }
        try {
            String[] split = token.split(DELIMITER_CONTINUATION_TOKEN, 2);
            if (split.length != 2) {
                return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)new RuntimeException("Split done incorrectly, must have partition and row key: " + token));
            }
            String nextPartitionKey = split[0];
            String nextRowKey = split[1];
            return this.listEntities(nextPartitionKey, nextRowKey, context, options, resultType);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private <T extends TableEntity> Mono<PagedResponse<T>> listEntities(String nextPartitionKey, String nextRowKey, Context context, ListEntitiesOptions options, Class<T> resultType) {
        context = context == null ? Context.NONE : context;
        QueryOptions queryOptions = new QueryOptions().setFilter(options.getFilter()).setTop(options.getTop()).setSelect(options.getSelect()).setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        return this.implementation.getTables().queryEntitiesWithResponseAsync(this.tableName, null, null, nextPartitionKey, nextRowKey, queryOptions, context).flatMap(response -> {
            TableEntityQueryResponse tablesQueryEntityResponse = response.getValue();
            if (tablesQueryEntityResponse == null) {
                return Mono.empty();
            }
            List<Map<String, Object>> entityResponseValue = tablesQueryEntityResponse.getValue();
            if (entityResponseValue == null) {
                return Mono.empty();
            }
            List entities = entityResponseValue.stream().map(ModelHelper::createEntity).map(e -> EntityHelper.convertToSubclass(e, resultType, this.logger)).collect(Collectors.toList());
            return Mono.just(new EntityPaged((Response<TableEntityQueryResponse>)response, entities, ((TablesQueryEntitiesHeaders)response.getDeserializedHeaders()).getXMsContinuationNextPartitionKey(), ((TablesQueryEntitiesHeaders)response.getDeserializedHeaders()).getXMsContinuationNextRowKey()));
        });
    }

    public Mono<TableEntity> getEntity(String partitionKey, String rowKey) {
        return this.getEntityWithResponse(partitionKey, rowKey, null).flatMap(FluxUtil::toMono);
    }

    public Mono<TableEntity> getEntity(String partitionKey, String rowKey, String select) {
        return this.getEntityWithResponse(partitionKey, rowKey, select).flatMap(FluxUtil::toMono);
    }

    public <T extends TableEntity> Mono<T> getEntity(String partitionKey, String rowKey, Class<T> resultType) {
        return this.getEntityWithResponse(partitionKey, rowKey, null, resultType).flatMap(FluxUtil::toMono);
    }

    public <T extends TableEntity> Mono<T> getEntity(String partitionKey, String rowKey, String select, Class<T> resultType) {
        return this.getEntityWithResponse(partitionKey, rowKey, select, resultType).flatMap(FluxUtil::toMono);
    }

    public Mono<Response<TableEntity>> getEntityWithResponse(String partitionKey, String rowKey, String select) {
        return FluxUtil.withContext(context -> this.getEntityWithResponse(partitionKey, rowKey, select, (Class)TableEntity.class, null, (Context)context));
    }

    public <T extends TableEntity> Mono<Response<T>> getEntityWithResponse(String partitionKey, String rowKey, String select, Class<T> resultType) {
        return FluxUtil.withContext(context -> this.getEntityWithResponse(partitionKey, rowKey, select, resultType, null, (Context)context));
    }

    <T extends TableEntity> Mono<Response<T>> getEntityWithResponse(String partitionKey, String rowKey, String select, Class<T> resultType, Duration timeout, Context context) {
        Integer timeoutInt = timeout == null ? null : Integer.valueOf((int)timeout.getSeconds());
        QueryOptions queryOptions = new QueryOptions().setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        if (select != null) {
            queryOptions.setSelect(select);
        }
        return this.implementation.getTables().queryEntityWithPartitionAndRowKeyWithResponseAsync(this.tableName, partitionKey, rowKey, timeoutInt, null, queryOptions, context).handle((response, sink) -> {
            Object matchingEntity = response.getValue();
            if (matchingEntity == null || matchingEntity.isEmpty()) {
                this.logger.info("There was no matching entity. Table: {}, partition key: {}, row key: {}.", new Object[]{this.tableName, partitionKey, rowKey});
                sink.complete();
                return;
            }
            TableEntity entity = ModelHelper.createEntity((Map<String, Object>)matchingEntity);
            sink.next((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), EntityHelper.convertToSubclass(entity, resultType, this.logger)));
        });
    }

    private static class EntityPaged<T extends TableEntity>
    implements PagedResponse<T> {
        private final Response<TableEntityQueryResponse> httpResponse;
        private final IterableStream<T> entityStream;
        private final String continuationToken;

        EntityPaged(Response<TableEntityQueryResponse> httpResponse, List<T> entityList, String nextPartitionKey, String nextRowKey) {
            this.continuationToken = nextPartitionKey == null || nextRowKey == null ? null : String.join((CharSequence)TableAsyncClient.DELIMITER_CONTINUATION_TOKEN, nextPartitionKey, nextRowKey);
            this.httpResponse = httpResponse;
            this.entityStream = IterableStream.of(entityList);
        }

        public int getStatusCode() {
            return this.httpResponse.getStatusCode();
        }

        public HttpHeaders getHeaders() {
            return this.httpResponse.getHeaders();
        }

        public HttpRequest getRequest() {
            return this.httpResponse.getRequest();
        }

        public IterableStream<T> getElements() {
            return this.entityStream;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public void close() {
        }
    }
}

