/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.tables.TableAsyncBatch;
import com.azure.data.tables.implementation.models.BatchOperation;
import com.azure.data.tables.models.BatchOperationResponse;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.UpdateMode;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;
import java.util.List;

public final class TableBatch {
    private final TableAsyncBatch batch;

    TableBatch(TableAsyncBatch batch) {
        this.batch = batch;
    }

    public TableBatch createEntity(TableEntity entity) {
        this.batch.createEntity(entity);
        return this;
    }

    public TableBatch upsertEntity(TableEntity entity) {
        this.batch.upsertEntity(entity);
        return this;
    }

    public TableBatch upsertEntity(TableEntity entity, UpdateMode updateMode) {
        this.batch.upsertEntity(entity, updateMode);
        return this;
    }

    public TableBatch updateEntity(TableEntity entity) {
        this.batch.updateEntity(entity);
        return this;
    }

    public TableBatch updateEntity(TableEntity entity, UpdateMode updateMode) {
        this.batch.updateEntity(entity, updateMode);
        return this;
    }

    public TableBatch updateEntity(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged) {
        this.batch.updateEntity(entity, updateMode, ifUnchanged);
        return this;
    }

    public TableBatch deleteEntity(String rowKey) {
        this.batch.deleteEntity(rowKey);
        return this;
    }

    public TableBatch deleteEntity(String rowKey, String eTag) {
        this.batch.deleteEntity(rowKey, eTag);
        return this;
    }

    public List<BatchOperation> getOperations() {
        return this.batch.getOperations();
    }

    public List<BatchOperationResponse> submitTransaction() {
        return (List)this.batch.submitTransaction().block();
    }

    public List<BatchOperationResponse> submitTransaction(Duration timeout) {
        return (List)StorageImplUtils.blockWithOptionalTimeout(this.batch.submitTransaction(), (Duration)timeout);
    }

    public Response<List<BatchOperationResponse>> submitTransactionWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.batch.submitTransactionWithResponse(context), (Duration)timeout);
    }
}

