/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.TableBatch;
import com.azure.data.tables.TablesServiceVersion;
import com.azure.data.tables.models.ListEntitiesOptions;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.UpdateMode;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;

public class TableClient {
    final TableAsyncClient client;

    TableClient(TableAsyncClient client) {
        this.client = client;
    }

    public String getTableName() {
        return this.client.getTableName();
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public String getTableUrl() {
        return this.client.getTableUrl();
    }

    public TablesServiceVersion getApiVersion() {
        return this.client.getApiVersion();
    }

    public TableBatch createBatch(String partitionKey) {
        return new TableBatch(this.client.createBatch(partitionKey));
    }

    public void create() {
        this.client.create().block();
    }

    public void create(Duration timeout) {
        StorageImplUtils.blockWithOptionalTimeout(this.client.create(), (Duration)timeout);
    }

    public Response<Void> createWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.createWithResponse(context), (Duration)timeout);
    }

    public void createEntity(TableEntity entity) {
        this.client.createEntity(entity).block();
    }

    public void createEntity(TableEntity entity, Duration timeout) {
        this.createEntityWithResponse(entity, timeout, null);
    }

    public Response<Void> createEntityWithResponse(TableEntity entity, Duration timeout, Context context) {
        return (Response)this.client.createEntityWithResponse(entity, timeout, context).block();
    }

    public void upsertEntity(TableEntity entity) {
        this.client.upsertEntity(entity).block();
    }

    public void upsertEntity(TableEntity entity, UpdateMode updateMode) {
        this.client.upsertEntity(entity, updateMode).block();
    }

    public void upsertEntity(TableEntity entity, UpdateMode updateMode, Duration timeout) {
        this.upsertEntityWithResponse(entity, updateMode, timeout, null);
    }

    public Response<Void> upsertEntityWithResponse(TableEntity entity, UpdateMode updateMode, Duration timeout, Context context) {
        return (Response)this.client.upsertEntityWithResponse(entity, updateMode, timeout, context).block();
    }

    public void updateEntity(TableEntity entity) {
        this.client.updateEntity(entity).block();
    }

    public void updateEntity(TableEntity entity, UpdateMode updateMode) {
        this.client.updateEntity(entity, updateMode).block();
    }

    public void updateEntity(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged) {
        this.client.updateEntity(entity, updateMode, ifUnchanged).block();
    }

    public void updateEntity(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged, Duration timeout) {
        this.updateEntityWithResponse(entity, updateMode, ifUnchanged, timeout, null);
    }

    public Response<Void> updateEntityWithResponse(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged, Duration timeout, Context context) {
        return (Response)this.client.updateEntityWithResponse(entity, updateMode, ifUnchanged, timeout, context).block();
    }

    public void delete() {
        this.client.delete().block();
    }

    public void delete(Duration timeout) {
        StorageImplUtils.blockWithOptionalTimeout(this.client.delete(), (Duration)timeout);
    }

    public Response<Void> deleteWithResponse(Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.deleteWithResponse(context), (Duration)timeout);
    }

    public void deleteEntity(String partitionKey, String rowKey) {
        this.client.deleteEntity(partitionKey, rowKey).block();
    }

    public void deleteEntity(String partitionKey, String rowKey, String eTag) {
        this.client.deleteEntity(partitionKey, rowKey, eTag).block();
    }

    public void deleteEntity(String partitionKey, String rowKey, String eTag, Duration timeout) {
        this.deleteEntityWithResponse(partitionKey, rowKey, eTag, timeout, null);
    }

    public Response<Void> deleteEntityWithResponse(String partitionKey, String rowKey, String eTag, Duration timeout, Context context) {
        return (Response)this.client.deleteEntityWithResponse(partitionKey, rowKey, eTag, timeout, context).block();
    }

    public PagedIterable<TableEntity> listEntities() {
        return new PagedIterable(this.client.listEntities());
    }

    public PagedIterable<TableEntity> listEntities(ListEntitiesOptions options) {
        return new PagedIterable(this.client.listEntities(options));
    }

    public <T extends TableEntity> PagedIterable<T> listEntities(Class<T> resultType) {
        return new PagedIterable(this.client.listEntities(resultType));
    }

    public <T extends TableEntity> PagedIterable<T> listEntities(ListEntitiesOptions options, Class<T> resultType) {
        return new PagedIterable(this.client.listEntities(options, resultType));
    }

    public TableEntity getEntity(String partitionKey, String rowKey) {
        return (TableEntity)this.client.getEntity(partitionKey, rowKey).block();
    }

    public TableEntity getEntity(String partitionKey, String rowKey, String select) {
        return (TableEntity)this.client.getEntity(partitionKey, rowKey, select).block();
    }

    public <T extends TableEntity> T getEntity(String partitionKey, String rowKey, Class<T> resultType) {
        return (T)((TableEntity)this.client.getEntity(partitionKey, rowKey, resultType).block());
    }

    public <T extends TableEntity> T getEntity(String partitionKey, String rowKey, String select, Class<T> resultType) {
        return (T)((TableEntity)this.client.getEntity(partitionKey, rowKey, select, resultType).block());
    }

    public TableEntity getEntity(String partitionKey, String rowKey, String select, Duration timeout) {
        return (TableEntity)this.getEntityWithResponse(partitionKey, rowKey, select, TableEntity.class, timeout, null).getValue();
    }

    public <T extends TableEntity> T getEntity(String partitionKey, String rowKey, String select, Class<T> resultType, Duration timeout) {
        return (T)((TableEntity)this.getEntityWithResponse(partitionKey, rowKey, select, resultType, timeout, null).getValue());
    }

    public Response<TableEntity> getEntityWithResponse(String partitionKey, String rowKey, String select, Duration timeout, Context context) {
        return (Response)this.client.getEntityWithResponse(partitionKey, rowKey, select, TableEntity.class, timeout, context).block();
    }

    public <T extends TableEntity> Response<T> getEntityWithResponse(String partitionKey, String rowKey, String select, Class<T> resultType, Duration timeout, Context context) {
        return (Response)this.client.getEntityWithResponse(partitionKey, rowKey, select, resultType, timeout, context).block();
    }
}

