/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.BuilderHelper;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TablesServiceVersion;
import com.azure.data.tables.TablesSharedKeyCredential;
import com.azure.data.tables.implementation.TablesJacksonSerializer;
import com.azure.storage.common.implementation.connectionstring.StorageAuthenticationSettings;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.common.implementation.connectionstring.StorageEndpoint;
import com.azure.storage.common.policy.RequestRetryOptions;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ServiceClientBuilder(serviceClients={TableClient.class, TableAsyncClient.class})
public class TableClientBuilder {
    private static final SerializerAdapter TABLES_SERIALIZER = new TablesJacksonSerializer();
    private final ClientLogger logger = new ClientLogger(TableClientBuilder.class);
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private String tableName;
    private Configuration configuration;
    private TokenCredential tokenCredential;
    private HttpClient httpClient;
    private String endpoint;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private HttpPipeline httpPipeline;
    private TablesSharedKeyCredential tablesSharedKeyCredential;
    private AzureSasCredential azureSasCredential;
    private String sasToken;
    private TablesServiceVersion version;
    private RequestRetryOptions retryOptions = new RequestRetryOptions();

    public TableClient buildClient() {
        return new TableClient(this.buildAsyncClient());
    }

    public TableAsyncClient buildAsyncClient() {
        TablesServiceVersion serviceVersion = this.version != null ? this.version : TablesServiceVersion.getLatest();
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(this.tablesSharedKeyCredential, this.tokenCredential, this.azureSasCredential, this.sasToken, this.endpoint, this.retryOptions, this.httpLogOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.logger);
        return new TableAsyncClient(this.tableName, pipeline, this.endpoint, serviceVersion, TABLES_SERIALIZER);
    }

    public TableClientBuilder connectionString(String connectionString) {
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectionString, (ClientLogger)this.logger);
        StorageEndpoint endpoint = storageConnectionString.getTableEndpoint();
        if (endpoint == null || endpoint.getPrimaryUri() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("connectionString missing required settings to derive tables service endpoint."));
        }
        this.endpoint(endpoint.getPrimaryUri());
        StorageAuthenticationSettings authSettings = storageConnectionString.getStorageAuthSettings();
        if (authSettings.getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
            this.credential(new TablesSharedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey()));
        } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
            this.sasToken(authSettings.getSasToken());
        }
        return this;
    }

    public TableClientBuilder endpoint(String endpoint) {
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL"));
        }
        this.endpoint = endpoint;
        return this;
    }

    public TableClientBuilder pipeline(HttpPipeline pipeline) {
        if (this.httpPipeline != null && pipeline == null) {
            this.logger.info("HttpPipeline is being set to 'null' when it was previously configured.");
        }
        this.httpPipeline = pipeline;
        return this;
    }

    public TableClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public TableClientBuilder sasToken(String sasToken) {
        this.sasToken = Objects.requireNonNull(sasToken, "'sasToken' cannot be null.");
        this.tablesSharedKeyCredential = null;
        this.tokenCredential = null;
        return this;
    }

    public TableClientBuilder credential(AzureSasCredential credential) {
        this.azureSasCredential = Objects.requireNonNull(credential, "'credential' cannot be null.");
        return this;
    }

    public TableClientBuilder credential(TablesSharedKeyCredential credential) {
        this.tablesSharedKeyCredential = Objects.requireNonNull(credential, "credential cannot be null.");
        this.tokenCredential = null;
        this.sasToken = null;
        return this;
    }

    public TableClientBuilder credential(TokenCredential credential) {
        this.tokenCredential = Objects.requireNonNull(credential, "credential cannot be null.");
        this.tablesSharedKeyCredential = null;
        this.sasToken = null;
        return this;
    }

    public TableClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            this.logger.error("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public TableClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = Objects.requireNonNull(logOptions, "'logOptions' cannot be null.");
        return this;
    }

    public TableClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        Objects.requireNonNull(pipelinePolicy, "'pipelinePolicy' cannot be null.");
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public TableClientBuilder serviceVersion(TablesServiceVersion version) {
        this.version = version;
        return this;
    }

    public TableClientBuilder retryOptions(RequestRetryOptions retryOptions) {
        this.retryOptions = Objects.requireNonNull(retryOptions, "'retryOptions' cannot be null.");
        return this;
    }

    public TableClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public TableClientBuilder tableName(String tableName) {
        this.tableName = Objects.requireNonNull(tableName, "'tableName' cannot be null.");
        return this;
    }
}

