/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.TableClientBuilder;
import com.azure.data.tables.TablesServiceVersion;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.AzureTableImplBuilder;
import com.azure.data.tables.implementation.ModelHelper;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TableQueryResponse;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.implementation.models.TablesQueryHeaders;
import com.azure.data.tables.models.ListTablesOptions;
import com.azure.data.tables.models.TableItem;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

public class TableServiceAsyncClient {
    private final ClientLogger logger = new ClientLogger(TableServiceAsyncClient.class);
    private final AzureTableImpl implementation;
    private final String accountName;
    private final HttpPipeline pipeline;

    TableServiceAsyncClient(HttpPipeline pipeline, String url, TablesServiceVersion serviceVersion, SerializerAdapter serializerAdapter) {
        try {
            URI uri = URI.create(url);
            this.accountName = uri.getHost().split("\\.", 2)[0];
            this.logger.verbose("Table Service URI: {}", new Object[]{uri});
        }
        catch (IllegalArgumentException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)ex);
        }
        this.implementation = new AzureTableImplBuilder().serializerAdapter(serializerAdapter).url(url).pipeline(pipeline).version(serviceVersion.getVersion()).buildClient();
        this.pipeline = this.implementation.getHttpPipeline();
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getServiceUrl() {
        return this.implementation.getUrl();
    }

    HttpPipeline getHttpPipeline() {
        return this.pipeline;
    }

    public TablesServiceVersion getApiVersion() {
        return TablesServiceVersion.fromString(this.implementation.getVersion());
    }

    public TableAsyncClient getTableClient(String tableName) {
        return new TableClientBuilder().pipeline(this.implementation.getHttpPipeline()).serviceVersion(this.getApiVersion()).endpoint(this.getServiceUrl()).tableName(tableName).buildAsyncClient();
    }

    public Mono<Void> createTable(String tableName) {
        return this.createTableWithResponse(tableName).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> createTableWithResponse(String tableName) {
        return FluxUtil.withContext(context -> this.createTableWithResponse(tableName, (Context)context));
    }

    Mono<Response<Void>> createTableWithResponse(String tableName, Context context) {
        context = context == null ? Context.NONE : context;
        TableProperties properties = new TableProperties().setTableName(tableName);
        try {
            return this.implementation.getTables().createWithResponseAsync(properties, null, ResponseFormat.RETURN_NO_CONTENT, null, context).map(response -> new SimpleResponse((Response)response, null));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    public Mono<Void> createTableIfNotExists(String tableName) {
        return this.createTableIfNotExistsWithResponse(tableName).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> createTableIfNotExistsWithResponse(String tableName) {
        return FluxUtil.withContext(context -> this.createTableIfNotExistsWithResponse(tableName, (Context)context));
    }

    Mono<Response<Void>> createTableIfNotExistsWithResponse(String tableName, Context context) {
        return this.createTableWithResponse(tableName, context).onErrorResume(e -> e instanceof TableServiceErrorException && ((TableServiceErrorException)((Object)((Object)e))).getResponse() != null && ((TableServiceErrorException)((Object)((Object)e))).getResponse().getStatusCode() == 409, e -> {
            HttpResponse response = ((TableServiceErrorException)((Object)((Object)e))).getResponse();
            return Mono.just((Object)new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), null));
        });
    }

    public Mono<Void> deleteTable(String tableName) {
        return this.deleteTableWithResponse(tableName).flatMap(response -> Mono.justOrEmpty((Object)((Void)response.getValue())));
    }

    public Mono<Response<Void>> deleteTableWithResponse(String tableName) {
        return FluxUtil.withContext(context -> this.deleteTableWithResponse(tableName, (Context)context));
    }

    Mono<Response<Void>> deleteTableWithResponse(String tableName, Context context) {
        context = context == null ? Context.NONE : context;
        return this.implementation.getTables().deleteWithResponseAsync(tableName, null, context).map(response -> new SimpleResponse((Response)response, null));
    }

    public PagedFlux<TableItem> listTables() {
        return this.listTables(new ListTablesOptions());
    }

    public PagedFlux<TableItem> listTables(ListTablesOptions options) {
        return new PagedFlux(() -> FluxUtil.withContext(context -> this.listTablesFirstPage((Context)context, options)), token -> FluxUtil.withContext(context -> this.listTablesNextPage((String)token, (Context)context, options)));
    }

    private Mono<PagedResponse<TableItem>> listTablesFirstPage(Context context, ListTablesOptions options) {
        try {
            return this.listTables(null, context, options);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private Mono<PagedResponse<TableItem>> listTablesNextPage(String token, Context context, ListTablesOptions options) {
        try {
            return this.listTables(token, context, options);
        }
        catch (RuntimeException e) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)e);
        }
    }

    private Mono<PagedResponse<TableItem>> listTables(String nextTableName, Context context, ListTablesOptions options) {
        context = context == null ? Context.NONE : context;
        QueryOptions queryOptions = new QueryOptions().setFilter(options.getFilter()).setTop(options.getTop()).setFormat(OdataMetadataFormat.APPLICATION_JSON_ODATA_FULLMETADATA);
        return this.implementation.getTables().queryWithResponseAsync(null, nextTableName, queryOptions, context).flatMap(response -> {
            TableQueryResponse tableQueryResponse = response.getValue();
            if (tableQueryResponse == null) {
                return Mono.empty();
            }
            List<TableResponseProperties> tableResponsePropertiesList = tableQueryResponse.getValue();
            if (tableResponsePropertiesList == null) {
                return Mono.empty();
            }
            List<TableItem> tables = tableResponsePropertiesList.stream().map(ModelHelper::createItem).collect(Collectors.toList());
            return Mono.just((Object)new TablePaged((Response<TableQueryResponse>)response, tables, ((TablesQueryHeaders)response.getDeserializedHeaders()).getXMsContinuationNextTableName()));
        });
    }

    private static class TablePaged
    implements PagedResponse<TableItem> {
        private final Response<TableQueryResponse> httpResponse;
        private final IterableStream<TableItem> tableStream;
        private final String continuationToken;

        TablePaged(Response<TableQueryResponse> httpResponse, List<TableItem> tableList, String continuationToken) {
            this.httpResponse = httpResponse;
            this.tableStream = IterableStream.of(tableList);
            this.continuationToken = continuationToken;
        }

        public int getStatusCode() {
            return this.httpResponse.getStatusCode();
        }

        public HttpHeaders getHeaders() {
            return this.httpResponse.getHeaders();
        }

        public HttpRequest getRequest() {
            return this.httpResponse.getRequest();
        }

        public IterableStream<TableItem> getElements() {
            return this.tableStream;
        }

        public String getContinuationToken() {
            return this.continuationToken;
        }

        public void close() {
        }
    }
}

