/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.data.tables.TableClient;
import com.azure.data.tables.TableServiceAsyncClient;
import com.azure.data.tables.TablesServiceVersion;
import com.azure.data.tables.models.ListTablesOptions;
import com.azure.data.tables.models.TableItem;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.time.Duration;

public class TableServiceClient {
    private final TableServiceAsyncClient client;

    TableServiceClient(TableServiceAsyncClient client) {
        this.client = client;
    }

    public String getAccountName() {
        return this.client.getAccountName();
    }

    public String getServiceUrl() {
        return this.client.getServiceUrl();
    }

    public TablesServiceVersion getApiVersion() {
        return this.client.getApiVersion();
    }

    public TableClient getTableClient(String tableName) {
        return new TableClient(this.client.getTableClient(tableName));
    }

    public void createTable(String tableName) {
        this.client.createTable(tableName).block();
    }

    public void createTable(String tableName, Duration timeout) {
        StorageImplUtils.blockWithOptionalTimeout(this.client.createTable(tableName), (Duration)timeout);
    }

    public Response<Void> createTableWithResponse(String tableName, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.createTableWithResponse(tableName, context), (Duration)timeout);
    }

    public void createTableIfNotExists(String tableName) {
        this.client.createTableIfNotExists(tableName).block();
    }

    public void createTableIfNotExists(String tableName, Duration timeout) {
        StorageImplUtils.blockWithOptionalTimeout(this.client.createTableIfNotExists(tableName), (Duration)timeout);
    }

    public Response<Void> createTableIfNotExistsWithResponse(String tableName, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.createTableIfNotExistsWithResponse(tableName, context), (Duration)timeout);
    }

    public void deleteTable(String tableName) {
        this.client.deleteTable(tableName).block();
    }

    public void deleteTable(String tableName, Duration timeout) {
        StorageImplUtils.blockWithOptionalTimeout(this.client.deleteTable(tableName), (Duration)timeout);
    }

    public Response<Void> deleteTableWithResponse(String tableName, Duration timeout, Context context) {
        return (Response)StorageImplUtils.blockWithOptionalTimeout(this.client.deleteTableWithResponse(tableName, context), (Duration)timeout);
    }

    public PagedIterable<TableItem> listTables() {
        return new PagedIterable(this.client.listTables());
    }

    public PagedIterable<TableItem> listTables(ListTablesOptions options) {
        return new PagedIterable(this.client.listTables(options));
    }
}

