/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.storage.common.implementation.StorageImplUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class TablesSharedKeyCredential {
    private static final String AUTHORIZATION_HEADER_FORMAT = "SharedKeyLite %s:%s";
    private final String accountName;
    private final String accountKey;

    public TablesSharedKeyCredential(String accountName, String accountKey) {
        this.accountName = Objects.requireNonNull(accountName, "'accountName' cannot be null.");
        this.accountKey = Objects.requireNonNull(accountKey, "'accountKey' cannot be null.");
    }

    String generateAuthorizationHeader(URL requestUrl, Map<String, String> headers) {
        String signature = StorageImplUtils.computeHMac256((String)this.accountKey, (String)this.buildStringToSign(requestUrl, headers));
        return String.format(AUTHORIZATION_HEADER_FORMAT, this.accountName, signature);
    }

    private String buildStringToSign(URL requestUrl, Map<String, String> headers) {
        String dateHeader = headers.containsKey("x-ms-date") ? "" : this.getStandardHeaderValue(headers, "Date");
        String s = String.join((CharSequence)"\n", dateHeader, this.getCanonicalizedResource(requestUrl));
        return s;
    }

    private String getStandardHeaderValue(Map<String, String> headers, String headerName) {
        String headerValue = headers.get(headerName);
        return headerValue == null ? "" : headerValue;
    }

    private String getCanonicalizedResource(URL requestUrl) {
        StringBuilder canonicalizedResource = new StringBuilder("/").append(this.accountName);
        if (requestUrl.getPath().length() > 0) {
            canonicalizedResource.append(requestUrl.getPath());
        } else {
            canonicalizedResource.append('/');
        }
        if (requestUrl.getQuery() != null) {
            Map queryParams = StorageImplUtils.parseQueryStringSplitValues((String)requestUrl.getQuery());
            ArrayList queryParamNames = new ArrayList(queryParams.keySet());
            Collections.sort(queryParamNames);
            for (String queryParamName : queryParamNames) {
                Object[] queryParamValues = (String[])queryParams.get(queryParamName);
                Arrays.sort(queryParamValues);
                String queryParamValuesStr = String.join((CharSequence)",", (CharSequence[])queryParamValues);
                if (!queryParamName.equalsIgnoreCase("comp")) continue;
                canonicalizedResource.append("?").append(queryParamName.toLowerCase(Locale.ROOT)).append("=").append(queryParamValuesStr);
            }
        }
        return canonicalizedResource.toString();
    }
}

