/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.models.BatchRequestBody;
import com.azure.data.tables.implementation.models.BatchSubmitBatchResponse;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import reactor.core.publisher.Mono;

public final class BatchImpl {
    private final BatchService service;
    private final AzureTableImpl client;

    public BatchImpl(AzureTableImpl client, SerializerAdapter serializerAdapter) {
        this.service = (BatchService)RestProxy.create(BatchService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)serializerAdapter);
        this.client = client;
    }

    public Mono<BatchSubmitBatchResponse> submitBatchWithRestResponseAsync(BatchRequestBody body, String requestId, Context context) {
        String dataServiceVersion = "3.0";
        return this.service.submitBatch(this.client.getUrl(), body.getContentType(), this.client.getVersion(), requestId, "3.0", body, context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureTableServices")
    private static interface BatchService {
        @Post(value="/$batch")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<BatchSubmitBatchResponse> submitBatch(@HostParam(value="url") String var1, @HeaderParam(value="Content-Type") String var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @BodyParam(value="multipart/mixed") BatchRequestBody var6, Context var7);
    }
}

