/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.models.BatchOperationResponse;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableItem;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ModelHelper {
    private static Supplier<TableEntity> entityCreator;
    private static Function<TableResponseProperties, TableItem> itemCreator;
    private static BiFunction<Integer, Object, BatchOperationResponse> batchOperationResponseCreator;
    private static BiConsumer<BatchOperationResponse, HttpRequest> batchOperationResponseUpdater;

    public static void setEntityCreator(Supplier<TableEntity> creator) {
        Objects.requireNonNull(creator, "'creator' cannot be null.");
        if (entityCreator != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'entityCreator' is already set."));
        }
        entityCreator = creator;
    }

    public static void setItemCreator(Function<TableResponseProperties, TableItem> creator) {
        Objects.requireNonNull(creator, "'creator' cannot be null.");
        if (itemCreator != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'itemCreator' is already set."));
        }
        itemCreator = creator;
    }

    public static void setBatchOperationResponseCreator(BiFunction<Integer, Object, BatchOperationResponse> creator) {
        Objects.requireNonNull(creator, "'creator' cannot be null.");
        if (batchOperationResponseCreator != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'batchOperationResponseCreator' is already set."));
        }
        batchOperationResponseCreator = creator;
    }

    public static void setBatchOperationResponseUpdater(BiConsumer<BatchOperationResponse, HttpRequest> updater) {
        Objects.requireNonNull(updater, "'updater' cannot be null.");
        if (batchOperationResponseUpdater != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'batchOperationResponseUpdater' is already set."));
        }
        batchOperationResponseUpdater = updater;
    }

    public static TableEntity createEntity(Map<String, Object> properties) {
        if (entityCreator == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'entityCreator' should not be null."));
        }
        return entityCreator.get().addProperties(properties);
    }

    public static TableItem createItem(TableResponseProperties properties) {
        if (itemCreator == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'itemCreator' should not be null."));
        }
        return itemCreator.apply(properties);
    }

    public static BatchOperationResponse createBatchOperationResponse(int statusCode, Object value) {
        if (batchOperationResponseCreator == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'batchOperationResponseCreator' should not be null."));
        }
        return batchOperationResponseCreator.apply(statusCode, value);
    }

    public static void updateBatchOperationResponse(BatchOperationResponse subject, HttpRequest request) {
        if (batchOperationResponseUpdater == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'batchOperationResponseUpdater' should not be null."));
        }
        batchOperationResponseUpdater.accept(subject, request);
    }

    static {
        try {
            Class.forName(TableEntity.class.getName(), true, TableEntity.class.getClassLoader());
            Class.forName(TableItem.class.getName(), true, TableItem.class.getClassLoader());
            Class.forName(BatchOperationResponse.class.getName(), true, BatchOperationResponse.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(new ClientLogger(ModelHelper.class).logThrowableAsError((Throwable)e));
        }
    }
}

