/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.implementation.AzureTableImpl;
import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.data.tables.implementation.models.QueryOptions;
import com.azure.data.tables.implementation.models.ResponseFormat;
import com.azure.data.tables.implementation.models.SignedIdentifier;
import com.azure.data.tables.implementation.models.TableProperties;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.implementation.models.TablesCreateResponse;
import com.azure.data.tables.implementation.models.TablesDeleteEntityResponse;
import com.azure.data.tables.implementation.models.TablesDeleteResponse;
import com.azure.data.tables.implementation.models.TablesGetAccessPolicyResponse;
import com.azure.data.tables.implementation.models.TablesInsertEntityResponse;
import com.azure.data.tables.implementation.models.TablesMergeEntityResponse;
import com.azure.data.tables.implementation.models.TablesQueryEntitiesResponse;
import com.azure.data.tables.implementation.models.TablesQueryEntityWithPartitionAndRowKeyResponse;
import com.azure.data.tables.implementation.models.TablesQueryResponse;
import com.azure.data.tables.implementation.models.TablesSetAccessPolicyResponse;
import com.azure.data.tables.implementation.models.TablesUpdateEntityResponse;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class TablesImpl {
    private final TablesService service;
    private final AzureTableImpl client;

    TablesImpl(AzureTableImpl client) {
        this.service = (TablesService)RestProxy.create(TablesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<TablesQueryResponse> queryWithResponseAsync(String requestId, String nextTableName, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.query(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, top, select, filter, nextTableName, "application/json;odata=minimalmetadata", context);
    }

    public Mono<TablesCreateResponse> createWithResponseAsync(TableProperties tableProperties, String requestId, ResponseFormat responsePreference, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.create(this.client.getUrl(), this.client.getVersion(), requestId, "3.0", format, responsePreference, tableProperties, "application/json;odata=minimalmetadata", context);
    }

    public Mono<TablesDeleteResponse> deleteWithResponseAsync(String table, String requestId, Context context) {
        String accept = "application/json";
        return this.service.delete(this.client.getUrl(), this.client.getVersion(), requestId, table, "application/json", context);
    }

    public Mono<TablesQueryEntitiesResponse> queryEntitiesWithResponseAsync(String table, Integer timeout, String requestId, String nextPartitionKey, String nextRowKey, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        Integer topInternal = null;
        if (queryOptions != null) {
            topInternal = queryOptions.getTop();
        }
        Integer top = topInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.queryEntities(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, top, select, filter, table, nextPartitionKey, nextRowKey, "application/json;odata=minimalmetadata", context);
    }

    public Mono<TablesQueryEntityWithPartitionAndRowKeyResponse> queryEntityWithPartitionAndRowKeyWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        String selectInternal = null;
        if (queryOptions != null) {
            selectInternal = queryOptions.getSelect();
        }
        String select = selectInternal;
        String filterInternal = null;
        if (queryOptions != null) {
            filterInternal = queryOptions.getFilter();
        }
        String filter = filterInternal;
        return this.service.queryEntityWithPartitionAndRowKey(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, select, filter, table, partitionKey, rowKey, "application/json;odata=minimalmetadata", context);
    }

    public Mono<TablesUpdateEntityResponse> updateEntityWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.updateEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", context);
    }

    public Mono<TablesMergeEntityResponse> mergeEntityWithResponseAsync(String table, String partitionKey, String rowKey, Integer timeout, String requestId, String ifMatch, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.mergeEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, tableEntityProperties, "application/json", context);
    }

    public Mono<TablesDeleteEntityResponse> deleteEntityWithResponseAsync(String table, String partitionKey, String rowKey, String ifMatch, Integer timeout, String requestId, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.deleteEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, partitionKey, rowKey, ifMatch, "application/json;odata=minimalmetadata", context);
    }

    public Mono<TablesInsertEntityResponse> insertEntityWithResponseAsync(String table, Integer timeout, String requestId, ResponseFormat responsePreference, Map<String, Object> tableEntityProperties, QueryOptions queryOptions, Context context) {
        String dataServiceVersion = "3.0";
        String accept = "application/json;odata=minimalmetadata";
        OdataMetadataFormat formatInternal = null;
        if (queryOptions != null) {
            formatInternal = queryOptions.getFormat();
        }
        OdataMetadataFormat format = formatInternal;
        return this.service.insertEntity(this.client.getUrl(), timeout, this.client.getVersion(), requestId, "3.0", format, table, responsePreference, tableEntityProperties, "application/json;odata=minimalmetadata", context);
    }

    public Mono<TablesGetAccessPolicyResponse> getAccessPolicyWithResponseAsync(String table, Integer timeout, String requestId, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.getAccessPolicy(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", "application/xml", context);
    }

    public Mono<TablesSetAccessPolicyResponse> setAccessPolicyWithResponseAsync(String table, Integer timeout, String requestId, List<SignedIdentifier> tableAcl, Context context) {
        String comp = "acl";
        String accept = "application/xml";
        return this.service.setAccessPolicy(this.client.getUrl(), timeout, this.client.getVersion(), requestId, table, "acl", tableAcl, "application/xml", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureTableTables")
    public static interface TablesService {
        @Get(value="/Tables")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesQueryResponse> query(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @HeaderParam(value="DataServiceVersion") String var4, @QueryParam(value="$format") OdataMetadataFormat var5, @QueryParam(value="$top") Integer var6, @QueryParam(value="$select") String var7, @QueryParam(value="$filter") String var8, @QueryParam(value="NextTableName") String var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Post(value="/Tables")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesCreateResponse> create(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @HeaderParam(value="DataServiceVersion") String var4, @QueryParam(value="$format") OdataMetadataFormat var5, @HeaderParam(value="Prefer") ResponseFormat var6, @BodyParam(value="application/json;odata=nometadata") TableProperties var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Delete(value="/Tables('{table}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesDeleteResponse> delete(@HostParam(value="url") String var1, @HeaderParam(value="x-ms-version") String var2, @HeaderParam(value="x-ms-client-request-id") String var3, @PathParam(value="table") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/{table}()")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesQueryEntitiesResponse> queryEntities(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @QueryParam(value="$top") Integer var7, @QueryParam(value="$select") String var8, @QueryParam(value="$filter") String var9, @PathParam(value="table") String var10, @QueryParam(value="NextPartitionKey") String var11, @QueryParam(value="NextRowKey") String var12, @HeaderParam(value="Accept") String var13, Context var14);

        @Get(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesQueryEntityWithPartitionAndRowKeyResponse> queryEntityWithPartitionAndRowKey(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @QueryParam(value="$select") String var7, @QueryParam(value="$filter") String var8, @PathParam(value="table") String var9, @PathParam(value="partitionKey") String var10, @PathParam(value="rowKey") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Put(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesUpdateEntityResponse> updateEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Patch(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesMergeEntityResponse> mergeEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @BodyParam(value="application/json") Map<String, Object> var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Delete(value="/{table}(PartitionKey='{partitionKey}',RowKey='{rowKey}')")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesDeleteEntityResponse> deleteEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @PathParam(value="partitionKey") String var8, @PathParam(value="rowKey") String var9, @HeaderParam(value="If-Match") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Post(value="/{table}")
        @ExpectedResponses(value={201, 204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesInsertEntityResponse> insertEntity(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @HeaderParam(value="DataServiceVersion") String var5, @QueryParam(value="$format") OdataMetadataFormat var6, @PathParam(value="table") String var7, @HeaderParam(value="Prefer") ResponseFormat var8, @BodyParam(value="application/json;odata=nometadata") Map<String, Object> var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Get(value="/{table}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesGetAccessPolicyResponse> getAccessPolicy(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @PathParam(value="table") String var5, @QueryParam(value="comp") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Put(value="/{table}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=TableServiceErrorException.class)
        public Mono<TablesSetAccessPolicyResponse> setAccessPolicy(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @PathParam(value="table") String var5, @QueryParam(value="comp") String var6, @BodyParam(value="application/xml") List<SignedIdentifier> var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

