/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.data.tables.implementation.EntityDataModelType;
import com.azure.data.tables.implementation.TablesConstants;
import com.azure.data.tables.implementation.models.TableEntityQueryResponse;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TablesJacksonSerializer
extends JacksonAdapter {
    private final ClientLogger logger = new ClientLogger(TablesJacksonSerializer.class);

    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        if (object instanceof Map) {
            super.serialize(this.insertTypeProperties(object), encoding, outputStream);
        } else {
            super.serialize(object, encoding, outputStream);
        }
    }

    private Map<String, Object> insertTypeProperties(Object o) {
        Map map = (Map)o;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            EntityDataModelType typeToTag;
            String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            if (propertyValue == null) continue;
            if (propertyValue instanceof Long) {
                result.put(propertyName, String.valueOf(propertyValue));
            } else {
                result.put(propertyName, propertyValue);
            }
            if (TablesConstants.METADATA_KEYS.contains(propertyName) || propertyName.endsWith("@odata.type") || (typeToTag = EntityDataModelType.forClass(propertyValue.getClass())) == null) continue;
            result.putIfAbsent(propertyName + "@odata.type", typeToTag.getEdmType());
        }
        return result;
    }

    public <U> U deserialize(String value, Type type, SerializerEncoding serializerEncoding) throws IOException {
        if (type == TableEntityQueryResponse.class || type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Map.class) {
            return this.deserialize(new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)), type, serializerEncoding);
        }
        return (U)super.deserialize(value, type, serializerEncoding);
    }

    public <U> U deserialize(InputStream inputStream, Type type, SerializerEncoding serializerEncoding) throws IOException {
        if (inputStream != null && type == TableEntityQueryResponse.class) {
            return this.deserializeTableEntityQueryResponse(inputStream);
        }
        if (inputStream != null && type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Map.class) {
            return this.deserializeTableEntity(inputStream);
        }
        return (U)super.deserialize(inputStream, type, serializerEncoding);
    }

    private <U> U deserializeTableEntity(InputStream inputStream) throws IOException {
        JsonNode node = super.serializer().readTree(inputStream);
        return (U)this.getEntityFieldsAsMap(node);
    }

    private <U> U deserializeTableEntityQueryResponse(InputStream inputStream) throws IOException {
        String odataMetadata = null;
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        JsonNode node = super.serializer().readTree(inputStream);
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String fieldName = (String)entry.getKey();
            JsonNode childNode = (JsonNode)entry.getValue();
            if (fieldName.equals("odata.metadata")) {
                odataMetadata = childNode.asText();
                continue;
            }
            if ("value".equals(fieldName) && childNode.isArray()) {
                for (JsonNode childEntry : childNode) {
                    values.add(this.getEntityFieldsAsMap(childEntry));
                }
                continue;
            }
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Unexpected response format. Response containing a 'value' array must not contain other properties."));
        }
        return (U)new TableEntityQueryResponse().setOdataMetadata(odataMetadata).setValue(values);
    }

    private Map<String, Object> getEntityFieldsAsMap(JsonNode node) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String fieldName = (String)it.next();
            if (fieldName.equals("odata.metadata")) continue;
            result.put(fieldName, this.getEntityFieldAsObject(node, fieldName));
        }
        return result;
    }

    private Object getEntityFieldAsObject(JsonNode parentNode, String fieldName) throws IOException {
        JsonNode valueNode = parentNode.get(fieldName);
        if (TablesConstants.METADATA_KEYS.contains(fieldName) || fieldName.endsWith("@odata.type")) {
            return this.serializer().treeToValue((TreeNode)valueNode, Object.class);
        }
        JsonNode typeNode = parentNode.get(fieldName + "@odata.type");
        if (typeNode == null) {
            return this.serializer().treeToValue((TreeNode)valueNode, Object.class);
        }
        String typeString = typeNode.asText();
        EntityDataModelType type = EntityDataModelType.fromString(typeString);
        if (type == null) {
            this.logger.warning(String.format("'%s' value has unknown OData type %s", fieldName, typeString));
            return this.serializer().treeToValue((TreeNode)valueNode, Object.class);
        }
        try {
            return type.deserialize(valueNode.asText());
        }
        catch (Exception e) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' value is not a valid %s.", fieldName, type.getEdmType()), e));
        }
    }
}

