/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.Response;
import com.azure.data.tables.TableAsyncClient;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.UpdateMode;
import reactor.core.publisher.Mono;

public interface BatchOperation {
    public Mono<HttpRequest> prepareRequest(TableAsyncClient var1);

    public static class DeleteEntity
    implements BatchOperation {
        private final String partitionKey;
        private final String rowKey;
        private final String eTag;

        public DeleteEntity(String partitionKey, String rowKey, String eTag) {
            this.partitionKey = partitionKey;
            this.rowKey = rowKey;
            this.eTag = eTag;
        }

        public String getPartitionKey() {
            return this.partitionKey;
        }

        public String getRowKey() {
            return this.rowKey;
        }

        public String getETag() {
            return this.eTag;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient preparer) {
            return preparer.deleteEntityWithResponse(this.partitionKey, this.rowKey, this.eTag).map(Response::getRequest);
        }

        public String toString() {
            return "DeleteEntity{partitionKey='" + this.partitionKey + '\'' + ", rowKey='" + this.rowKey + '\'' + ", eTag='" + this.eTag + '\'' + '}';
        }
    }

    public static class UpdateEntity
    implements BatchOperation {
        private final TableEntity entity;
        private final UpdateMode updateMode;
        private final boolean ifUnchanged;

        public UpdateEntity(TableEntity entity, UpdateMode updateMode, boolean ifUnchanged) {
            this.entity = entity;
            this.updateMode = updateMode;
            this.ifUnchanged = ifUnchanged;
        }

        public TableEntity getEntity() {
            return this.entity;
        }

        public UpdateMode getUpdateMode() {
            return this.updateMode;
        }

        public boolean getIfUnchanged() {
            return this.ifUnchanged;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient preparer) {
            return preparer.updateEntityWithResponse(this.entity, this.updateMode, this.ifUnchanged).map(Response::getRequest);
        }

        public String toString() {
            return "UpdateEntity{partitionKey='" + this.entity.getPartitionKey() + '\'' + ", rowKey='" + this.entity.getRowKey() + '\'' + ", updateMode=" + (Object)((Object)this.updateMode) + ", ifUnchanged=" + this.ifUnchanged + '}';
        }
    }

    public static class UpsertEntity
    implements BatchOperation {
        private final TableEntity entity;
        private final UpdateMode updateMode;

        public UpsertEntity(TableEntity entity, UpdateMode updateMode) {
            this.entity = entity;
            this.updateMode = updateMode;
        }

        public TableEntity getEntity() {
            return this.entity;
        }

        public UpdateMode getUpdateMode() {
            return this.updateMode;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient preparer) {
            return preparer.upsertEntityWithResponse(this.entity, this.updateMode).map(Response::getRequest);
        }

        public String toString() {
            return "UpsertEntity{partitionKey='" + this.entity.getPartitionKey() + '\'' + ", rowKey='" + this.entity.getRowKey() + '\'' + ", updateMode=" + (Object)((Object)this.updateMode) + '}';
        }
    }

    public static class CreateEntity
    implements BatchOperation {
        private final TableEntity entity;

        public CreateEntity(TableEntity entity) {
            this.entity = entity;
        }

        public TableEntity getEntity() {
            return this.entity;
        }

        @Override
        public Mono<HttpRequest> prepareRequest(TableAsyncClient client) {
            return client.createEntityWithResponse(this.entity).map(Response::getRequest);
        }

        public String toString() {
            return "CreateEntity{partitionKey='" + this.entity.getPartitionKey() + '\'' + ", rowKey='" + this.entity.getRowKey() + '\'' + '}';
        }
    }
}

