/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.BatchChangeSet;
import com.azure.data.tables.implementation.models.BatchSubRequest;
import com.azure.data.tables.implementation.models.MultipartPart;

public final class BatchRequestBody
extends MultipartPart<Object> {
    private final ClientLogger logger = new ClientLogger(BatchRequestBody.class);
    private BatchChangeSet changeSet = null;
    private boolean queryAdded = false;

    public BatchRequestBody() {
        super("batch");
    }

    public BatchRequestBody addQueryOperation(BatchSubRequest queryRequest) {
        if (this.changeSet != null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot add a query operation to a BatchRequestBody containing a changeset."));
        }
        this.addContent(queryRequest);
        this.queryAdded = true;
        return this;
    }

    public BatchRequestBody addChangeOperation(BatchSubRequest changeRequest) {
        if (this.queryAdded) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot add a change operation to a BatchRequestBody containing query operations."));
        }
        if (this.changeSet == null) {
            this.changeSet = new BatchChangeSet();
            this.addContent(this.changeSet);
        }
        this.changeSet.addContent(changeRequest);
        return this;
    }
}

