/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class MultipartPart<T> {
    private static final String CONTENT_TYPE_PREFIX = "multipart/mixed; boundary=";
    private final String boundary;
    private final List<T> contents = new ArrayList<T>();

    public MultipartPart(String boundaryPrefix) {
        this.boundary = boundaryPrefix + "_" + UUID.randomUUID().toString();
    }

    public String getContentType() {
        return CONTENT_TYPE_PREFIX + this.boundary;
    }

    public String getBoundary() {
        return this.boundary;
    }

    public List<T> getContents() {
        return this.contents;
    }

    protected MultipartPart<T> addContent(T content) {
        this.contents.add(content);
        return this;
    }
}

