/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.ModelHelper;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TableEntity {
    private final ClientLogger logger = new ClientLogger(TableEntity.class);
    private final Map<String, Object> properties;

    public TableEntity(String partitionKey, String rowKey) {
        if (partitionKey == null || partitionKey.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' is an empty value.", "PartitionKey")));
        }
        if (rowKey == null || rowKey.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' is an empty value.", "RowKey")));
        }
        this.properties = new HashMap<String, Object>();
        this.properties.put("PartitionKey", partitionKey);
        this.properties.put("RowKey", rowKey);
    }

    private TableEntity() {
        this.properties = new HashMap<String, Object>();
    }

    public final Object getProperty(String key) {
        return this.properties.get(key);
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final TableEntity addProperty(String key, Object value) {
        this.validateProperty(key, value);
        this.properties.put(key, value);
        return this;
    }

    public final TableEntity addProperties(Map<String, Object> properties) {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.validateProperty(entry.getKey(), entry.getValue());
        }
        this.properties.putAll(properties);
        return this;
    }

    private void validateProperty(String key, Object value) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (("PartitionKey".equals(key) || "RowKey".equals(key)) && value != null && (!(value instanceof String) || ((String)value).isEmpty())) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' must be a non-empty String.", key)));
        }
        if ("Timestamp".equals(key) && value != null && !(value instanceof OffsetDateTime)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' must be an OffsetDateTime.", key)));
        }
        if (("odata.etag".equals(key) || "odata.editLink".equals(key) || "odata.id".equals(key) || "odata.type".equals(key)) && value != null && !(value instanceof String)) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' must be a String.", key)));
        }
    }

    public final String getRowKey() {
        return (String)this.properties.get("RowKey");
    }

    public final String getPartitionKey() {
        return (String)this.properties.get("PartitionKey");
    }

    public final OffsetDateTime getTimestamp() {
        return (OffsetDateTime)this.properties.get("Timestamp");
    }

    public final String getETag() {
        return (String)this.properties.get("odata.etag");
    }

    final String getOdataType() {
        return (String)this.properties.get("odata.type");
    }

    final String getOdataId() {
        return (String)this.properties.get("odata.id");
    }

    final String getOdataEditLink() {
        return (String)this.properties.get("odata.editLink");
    }

    static {
        ModelHelper.setEntityCreator(TableEntity::new);
    }
}

