/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.http.HttpRequest;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.TableResponseProperties;
import com.azure.data.tables.models.TableEntity;
import com.azure.data.tables.models.TableItem;
import com.azure.data.tables.models.TableTransactionActionResponse;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public final class ModelHelper {
    private static Supplier<TableEntity> entityCreator;
    private static Function<TableResponseProperties, TableItem> itemCreator;
    private static BiFunction<Integer, Object, TableTransactionActionResponse> tableTransactionActionResponseCreator;
    private static BiConsumer<TableTransactionActionResponse, HttpRequest> tableTransactionActionResponseUpdater;

    public static void setEntityCreator(Supplier<TableEntity> creator) {
        Objects.requireNonNull(creator, "'creator' cannot be null.");
        if (entityCreator != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'entityCreator' is already set."));
        }
        entityCreator = creator;
    }

    public static void setItemCreator(Function<TableResponseProperties, TableItem> creator) {
        Objects.requireNonNull(creator, "'creator' cannot be null.");
        if (itemCreator != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'itemCreator' is already set."));
        }
        itemCreator = creator;
    }

    public static void setTableTransactionActionResponseCreator(BiFunction<Integer, Object, TableTransactionActionResponse> creator) {
        Objects.requireNonNull(creator, "'creator' cannot be null.");
        if (tableTransactionActionResponseCreator != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'tableTransactionActionResponseCreator' is already set."));
        }
        tableTransactionActionResponseCreator = creator;
    }

    public static void setTableTransactionActionResponseUpdater(BiConsumer<TableTransactionActionResponse, HttpRequest> updater) {
        Objects.requireNonNull(updater, "'updater' cannot be null.");
        if (tableTransactionActionResponseUpdater != null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'tableTransactionActionResponseUpdater' is already set."));
        }
        tableTransactionActionResponseUpdater = updater;
    }

    public static TableEntity createEntity(Map<String, Object> properties) {
        if (entityCreator == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'entityCreator' should not be null."));
        }
        return entityCreator.get().setProperties(properties);
    }

    public static TableItem createItem(TableResponseProperties properties) {
        if (itemCreator == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'itemCreator' should not be null."));
        }
        return itemCreator.apply(properties);
    }

    public static TableTransactionActionResponse createTableTransactionActionResponse(int statusCode, Object value) {
        if (tableTransactionActionResponseCreator == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'tableTransactionActionResponseCreator' should not be null."));
        }
        return tableTransactionActionResponseCreator.apply(statusCode, value);
    }

    public static void updateTableTransactionActionResponse(TableTransactionActionResponse subject, HttpRequest request) {
        if (tableTransactionActionResponseUpdater == null) {
            throw new ClientLogger(ModelHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'tableTransactionActionResponseUpdater' should not be null."));
        }
        tableTransactionActionResponseUpdater.accept(subject, request);
    }

    static {
        try {
            Class.forName(TableEntity.class.getName(), true, TableEntity.class.getClassLoader());
            Class.forName(TableItem.class.getName(), true, TableItem.class.getClassLoader());
            Class.forName(TableTransactionActionResponse.class.getName(), true, TableTransactionActionResponse.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(new ClientLogger(ModelHelper.class).logThrowableAsError((Throwable)e));
        }
    }
}

