/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.data.tables.implementation.TableSasUtils;
import com.azure.data.tables.implementation.TableUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class TableAzureNamedKeyCredentialPolicy
implements HttpPipelinePolicy {
    private static final String AUTHORIZATION_HEADER_FORMAT = "SharedKeyLite %s:%s";
    private final AzureNamedKeyCredential credential;

    public TableAzureNamedKeyCredentialPolicy(AzureNamedKeyCredential credential) {
        this.credential = credential;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        String authorizationValue = this.generateAuthorizationHeader(context.getHttpRequest().getUrl(), context.getHttpRequest().getHeaders().toMap());
        context.getHttpRequest().setHeader("Authorization", authorizationValue);
        return next.process();
    }

    String generateAuthorizationHeader(URL requestUrl, Map<String, String> headers) {
        String signature = TableSasUtils.computeHmac256(this.credential.getAzureNamedKey().getKey(), this.buildStringToSign(requestUrl, headers));
        return String.format(AUTHORIZATION_HEADER_FORMAT, this.credential.getAzureNamedKey().getName(), signature);
    }

    private String buildStringToSign(URL requestUrl, Map<String, String> headers) {
        String dateHeader = headers.containsKey("x-ms-date") ? "" : this.getStandardHeaderValue(headers, "Date");
        String s = String.join((CharSequence)"\n", dateHeader, this.getCanonicalizedResource(requestUrl));
        return s;
    }

    private String getStandardHeaderValue(Map<String, String> headers, String headerName) {
        String headerValue = headers.get(headerName);
        return headerValue == null ? "" : headerValue;
    }

    private String getCanonicalizedResource(URL requestUrl) {
        StringBuilder canonicalizedResource = new StringBuilder("/").append(this.credential.getAzureNamedKey().getName());
        if (requestUrl.getPath().length() > 0) {
            canonicalizedResource.append(requestUrl.getPath());
        } else {
            canonicalizedResource.append('/');
        }
        if (requestUrl.getQuery() != null) {
            Map<String, String[]> queryParams = TableUtils.parseQueryStringSplitValues(requestUrl.getQuery());
            ArrayList<String> queryParamNames = new ArrayList<String>(queryParams.keySet());
            Collections.sort(queryParamNames);
            for (String queryParamName : queryParamNames) {
                Object[] queryParamValues = queryParams.get(queryParamName);
                Arrays.sort(queryParamValues);
                String queryParamValuesStr = String.join((CharSequence)",", (CharSequence[])queryParamValues);
                if (!"comp".equalsIgnoreCase(queryParamName)) continue;
                canonicalizedResource.append("?").append(queryParamName.toLowerCase(Locale.ROOT)).append("=").append(queryParamValuesStr);
            }
        }
        return canonicalizedResource.toString();
    }

    public AzureNamedKeyCredential getCredential() {
        return this.credential;
    }
}

