/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.util.CoreUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import reactor.core.publisher.Mono;

public class TableBearerTokenChallengeAuthorizationPolicy
extends BearerTokenAuthenticationPolicy {
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    private String[] scopes;
    private volatile String tenantId;
    private boolean enableTenantDiscovery;

    public TableBearerTokenChallengeAuthorizationPolicy(TokenCredential credential, boolean enableTenantDiscovery, String ... scopes) {
        super(credential, scopes);
        this.scopes = scopes;
        this.enableTenantDiscovery = enableTenantDiscovery;
    }

    private static Map<String, String> extractChallengeAttributes(String authenticateHeader, String authChallengePrefix) {
        if (!TableBearerTokenChallengeAuthorizationPolicy.isBearerChallenge(authenticateHeader, authChallengePrefix)) {
            return Collections.emptyMap();
        }
        authenticateHeader = authenticateHeader.toLowerCase(Locale.ROOT).replace(authChallengePrefix.toLowerCase(Locale.ROOT), "");
        String[] attributes = authenticateHeader.split(" ");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributes) {
            String[] keyValue = pair.split("=");
            attributeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        return attributeMap;
    }

    private static boolean isBearerChallenge(String authenticateHeader, String authChallengePrefix) {
        return !CoreUtils.isNullOrEmpty((CharSequence)authenticateHeader) && authenticateHeader.toLowerCase(Locale.ROOT).startsWith(authChallengePrefix.toLowerCase(Locale.ROOT));
    }

    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        return Mono.defer(() -> {
            if (this.tenantId != null || !this.enableTenantDiscovery) {
                TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.scopes).setTenantId(this.tenantId);
                return this.setAuthorizationHeader(context, tokenRequestContext);
            }
            return Mono.empty();
        });
    }

    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        return Mono.defer(() -> {
            URI authorizationUri;
            Map<String, String> challengeAttributes = TableBearerTokenChallengeAuthorizationPolicy.extractChallengeAttributes(response.getHeaderValue(WWW_AUTHENTICATE), BEARER_TOKEN_PREFIX);
            String authorizationUriString = challengeAttributes.get("authorization_uri");
            try {
                authorizationUri = new URI(authorizationUriString);
            }
            catch (URISyntaxException e) {
                return Mono.just((Object)false);
            }
            this.tenantId = authorizationUri.getPath().split("/")[1];
            TokenRequestContext tokenRequestContext = new TokenRequestContext().addScopes(this.scopes).setTenantId(this.tenantId);
            return this.setAuthorizationHeader(context, tokenRequestContext).then(Mono.just((Object)true));
        });
    }
}

