// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.data.tables.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/** The response for a single table. */
@JacksonXmlRootElement(localName = "TableResponse")
@Fluent
public final class TableResponse extends TableResponseProperties {
    /*
     * The metadata response of the table.
     */
    @JsonProperty(value = "odata.metadata")
    private String odataMetadata;

    /** Creates an instance of TableResponse class. */
    public TableResponse() {}

    /**
     * Get the odataMetadata property: The metadata response of the table.
     *
     * @return the odataMetadata value.
     */
    public String getOdataMetadata() {
        return this.odataMetadata;
    }

    /**
     * Set the odataMetadata property: The metadata response of the table.
     *
     * @param odataMetadata the odataMetadata value to set.
     * @return the TableResponse object itself.
     */
    public TableResponse setOdataMetadata(String odataMetadata) {
        this.odataMetadata = odataMetadata;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public TableResponse setTableName(String tableName) {
        super.setTableName(tableName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public TableResponse setOdataType(String odataType) {
        super.setOdataType(odataType);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public TableResponse setOdataId(String odataId) {
        super.setOdataId(odataId);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public TableResponse setOdataEditLink(String odataEditLink) {
        super.setOdataEditLink(odataEditLink);
        return this;
    }
}
