/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.implementation.models.AccessPolicy;
import com.azure.data.tables.implementation.models.CorsRule;
import com.azure.data.tables.implementation.models.GeoReplication;
import com.azure.data.tables.implementation.models.Logging;
import com.azure.data.tables.implementation.models.Metrics;
import com.azure.data.tables.implementation.models.RetentionPolicy;
import com.azure.data.tables.implementation.models.SignedIdentifier;
import com.azure.data.tables.implementation.models.TableServiceError;
import com.azure.data.tables.implementation.models.TableServiceErrorException;
import com.azure.data.tables.implementation.models.TableServiceErrorOdataError;
import com.azure.data.tables.implementation.models.TableServiceErrorOdataErrorMessage;
import com.azure.data.tables.implementation.models.TableServiceProperties;
import com.azure.data.tables.implementation.models.TableServiceStats;
import com.azure.data.tables.models.TableAccessPolicy;
import com.azure.data.tables.models.TableServiceCorsRule;
import com.azure.data.tables.models.TableServiceException;
import com.azure.data.tables.models.TableServiceGeoReplication;
import com.azure.data.tables.models.TableServiceGeoReplicationStatus;
import com.azure.data.tables.models.TableServiceLogging;
import com.azure.data.tables.models.TableServiceMetrics;
import com.azure.data.tables.models.TableServiceRetentionPolicy;
import com.azure.data.tables.models.TableServiceStatistics;
import com.azure.data.tables.models.TableSignedIdentifier;
import com.azure.data.tables.models.TableTransactionFailedException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.Duration;
import java.util.Locale;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class TableUtils {
    private static final String UTF8_CHARSET = "UTF-8";
    private static final String HTTP_REST_PROXY_SYNC_PROXY_ENABLE = "com.azure.core.http.restproxy.syncproxy.enable";
    private static final String TABLES_TRACING_NAMESPACE_VALUE = "Microsoft.Tables";
    private static final long THREADPOOL_SHUTDOWN_HOOK_TIMEOUT_SECINDS = 5L;

    private TableUtils() {
        throw new UnsupportedOperationException("Cannot instantiate TablesUtils");
    }

    public static com.azure.data.tables.models.TableServiceError toTableServiceError(TableServiceError tableServiceError) {
        TableServiceErrorOdataError odataError;
        String errorCode = null;
        String errorMessage = null;
        if (tableServiceError != null && (odataError = tableServiceError.getOdataError()) != null) {
            errorCode = odataError.getCode();
            TableServiceErrorOdataErrorMessage odataErrorMessage = odataError.getMessage();
            if (odataErrorMessage != null) {
                errorMessage = odataErrorMessage.getValue();
            }
        }
        return new com.azure.data.tables.models.TableServiceError(errorCode, errorMessage);
    }

    public static TableServiceException toTableServiceException(TableServiceErrorException exception) {
        return new TableServiceException(exception.getMessage(), exception.getResponse(), TableUtils.toTableServiceError(exception.getValue()));
    }

    public static Throwable mapThrowableToTableServiceException(Throwable throwable) {
        Throwable cause;
        if (throwable instanceof TableServiceErrorException) {
            return TableUtils.toTableServiceException((TableServiceErrorException)((Object)throwable));
        }
        if (throwable.getCause() instanceof Exception && (cause = throwable.getCause()) instanceof TableServiceErrorException) {
            return TableUtils.toTableServiceException((TableServiceErrorException)((Object)cause));
        }
        return throwable;
    }

    public static <T> Mono<T> applyOptionalTimeout(Mono<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <T> Flux<T> applyOptionalTimeout(Flux<T> publisher, Duration timeout) {
        return timeout == null ? publisher : publisher.timeout(timeout);
    }

    public static <T> T blockWithOptionalTimeout(Mono<T> response, Duration timeout) {
        if (timeout == null) {
            return (T)response.block();
        }
        return (T)response.block(timeout);
    }

    public static <E extends HttpResponseException> Mono<Response<Void>> swallowExceptionForStatusCode(int statusCode, E httpResponseException, ClientLogger logger) {
        HttpResponse httpResponse = httpResponseException.getResponse();
        if (httpResponse.getStatusCode() == statusCode) {
            return Mono.just((Object)new SimpleResponse(httpResponse.getRequest(), httpResponse.getStatusCode(), httpResponse.getHeaders(), null));
        }
        return FluxUtil.monoError((ClientLogger)logger, httpResponseException);
    }

    public static Context setContext(Context context) {
        return TableUtils.setContext(context, false);
    }

    public static Context setContext(Context context, boolean isSync) {
        Context val = context != null ? context : Context.NONE;
        return isSync ? TableUtils.enableSyncRestProxy(TableUtils.setTrailingContext(val)) : TableUtils.setTrailingContext(val);
    }

    private static Context setTrailingContext(Context context) {
        return context.addData((Object)"az.namespace", (Object)TABLES_TRACING_NAMESPACE_VALUE);
    }

    private static Context enableSyncRestProxy(Context context) {
        return context.addData((Object)HTTP_REST_PROXY_SYNC_PROXY_ENABLE, (Object)true);
    }

    public static OptionalLong setTimeout(Duration timeout) {
        return timeout != null ? OptionalLong.of(timeout.toMillis()) : OptionalLong.empty();
    }

    public static Map<String, String[]> parseQueryStringSplitValues(String queryString) {
        return TableUtils.parseQueryStringHelper(queryString, value -> {
            String[] v = value.split(",");
            String[] ret = new String[v.length];
            for (int i = 0; i < v.length; ++i) {
                ret[i] = TableUtils.urlDecode(v[i]);
            }
            return ret;
        });
    }

    private static <T> Map<String, T> parseQueryStringHelper(String queryString, Function<String, T> valueParser) {
        TreeMap<String, T> pieces = new TreeMap<String, T>();
        if (CoreUtils.isNullOrEmpty((CharSequence)queryString)) {
            return pieces;
        }
        for (String kvp : queryString.split("&")) {
            int equalIndex = kvp.indexOf("=");
            String key = TableUtils.urlDecode(kvp.substring(0, equalIndex).toLowerCase(Locale.ROOT));
            T value = valueParser.apply(kvp.substring(equalIndex + 1));
            pieces.putIfAbsent(key, value);
        }
        return pieces;
    }

    public static String urlDecode(String stringToDecode) {
        if (CoreUtils.isNullOrEmpty((CharSequence)stringToDecode)) {
            return "";
        }
        if (stringToDecode.contains("+")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToDecode.length(); ++m) {
                if (stringToDecode.charAt(m) != '+') continue;
                if (m > startDex) {
                    outBuilder.append(TableUtils.decode(stringToDecode.substring(startDex, m)));
                }
                outBuilder.append("+");
                startDex = m + 1;
            }
            if (startDex != stringToDecode.length()) {
                outBuilder.append(TableUtils.decode(stringToDecode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return TableUtils.decode(stringToDecode);
    }

    private static String decode(String stringToDecode) {
        try {
            return URLDecoder.decode(stringToDecode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String urlEncode(String stringToEncode) {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.length() == 0) {
            return "";
        }
        if (stringToEncode.contains(" ")) {
            StringBuilder outBuilder = new StringBuilder();
            int startDex = 0;
            for (int m = 0; m < stringToEncode.length(); ++m) {
                if (stringToEncode.charAt(m) != ' ') continue;
                if (m > startDex) {
                    outBuilder.append(TableUtils.encode(stringToEncode.substring(startDex, m)));
                }
                outBuilder.append("%20");
                startDex = m + 1;
            }
            if (startDex != stringToEncode.length()) {
                outBuilder.append(TableUtils.encode(stringToEncode.substring(startDex)));
            }
            return outBuilder.toString();
        }
        return TableUtils.encode(stringToEncode);
    }

    private static String encode(String stringToEncode) {
        try {
            return URLEncoder.encode(stringToEncode, UTF8_CHARSET);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ExecutorService getThreadPoolWithShutdownHook() {
        ExecutorService threadPool = Executors.newCachedThreadPool();
        TableUtils.registerShutdownHook(threadPool);
        return threadPool;
    }

    static Thread registerShutdownHook(ExecutorService threadPool) {
        long halfTimeout = TimeUnit.SECONDS.toNanos(5L) / 2L;
        Thread hook = new Thread(() -> {
            try {
                threadPool.shutdown();
                if (!threadPool.awaitTermination(halfTimeout, TimeUnit.NANOSECONDS)) {
                    threadPool.shutdownNow();
                    threadPool.awaitTermination(halfTimeout, TimeUnit.NANOSECONDS);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                threadPool.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(hook);
        return hook;
    }

    public static com.azure.data.tables.models.TableServiceProperties toTableServiceProperties(TableServiceProperties tableServiceProperties) {
        if (tableServiceProperties == null) {
            return null;
        }
        return new com.azure.data.tables.models.TableServiceProperties().setLogging(TableUtils.toTableServiceLogging(tableServiceProperties.getLogging())).setHourMetrics(TableUtils.toTableServiceMetrics(tableServiceProperties.getHourMetrics())).setMinuteMetrics(TableUtils.toTableServiceMetrics(tableServiceProperties.getMinuteMetrics())).setCorsRules(tableServiceProperties.getCors() == null ? null : tableServiceProperties.getCors().stream().map(TableUtils::toTablesServiceCorsRule).collect(Collectors.toList()));
    }

    static TableServiceRetentionPolicy toTableServiceRetentionPolicy(RetentionPolicy retentionPolicy) {
        if (retentionPolicy == null) {
            return null;
        }
        return new TableServiceRetentionPolicy().setEnabled(retentionPolicy.isEnabled()).setDaysToRetain(retentionPolicy.getDays());
    }

    static TableServiceMetrics toTableServiceMetrics(Metrics metrics) {
        if (metrics == null) {
            return null;
        }
        return new TableServiceMetrics().setVersion(metrics.getVersion()).setEnabled(metrics.isEnabled()).setIncludeApis(metrics.isIncludeAPIs()).setRetentionPolicy(TableUtils.toTableServiceRetentionPolicy(metrics.getRetentionPolicy()));
    }

    static TableServiceCorsRule toTablesServiceCorsRule(CorsRule corsRule) {
        if (corsRule == null) {
            return null;
        }
        return new TableServiceCorsRule().setAllowedOrigins(corsRule.getAllowedOrigins()).setAllowedMethods(corsRule.getAllowedMethods()).setAllowedHeaders(corsRule.getAllowedHeaders()).setExposedHeaders(corsRule.getExposedHeaders()).setMaxAgeInSeconds(corsRule.getMaxAgeInSeconds());
    }

    static TableServiceLogging toTableServiceLogging(Logging logging) {
        if (logging == null) {
            return null;
        }
        return new TableServiceLogging().setAnalyticsVersion(logging.getVersion()).setDeleteLogged(logging.isDelete()).setReadLogged(logging.isRead()).setWriteLogged(logging.isWrite()).setRetentionPolicy(TableUtils.toTableServiceRetentionPolicy(logging.getRetentionPolicy()));
    }

    public static TableServiceProperties toImplTableServiceProperties(com.azure.data.tables.models.TableServiceProperties tableServiceProperties) {
        return new TableServiceProperties().setLogging(TableUtils.toLogging(tableServiceProperties.getLogging())).setHourMetrics(TableUtils.toMetrics(tableServiceProperties.getHourMetrics())).setMinuteMetrics(TableUtils.toMetrics(tableServiceProperties.getMinuteMetrics())).setCors(tableServiceProperties.getCorsRules() == null ? null : tableServiceProperties.getCorsRules().stream().map(TableUtils::toCorsRule).collect(Collectors.toList()));
    }

    static Logging toLogging(TableServiceLogging tableServiceLogging) {
        if (tableServiceLogging == null) {
            return null;
        }
        return new Logging().setVersion(tableServiceLogging.getAnalyticsVersion()).setDelete(tableServiceLogging.isDeleteLogged()).setRead(tableServiceLogging.isReadLogged()).setWrite(tableServiceLogging.isWriteLogged()).setRetentionPolicy(TableUtils.toRetentionPolicy(tableServiceLogging.getRetentionPolicy()));
    }

    static RetentionPolicy toRetentionPolicy(TableServiceRetentionPolicy tableServiceRetentionPolicy) {
        if (tableServiceRetentionPolicy == null) {
            return null;
        }
        return new RetentionPolicy().setEnabled(tableServiceRetentionPolicy.isEnabled()).setDays(tableServiceRetentionPolicy.getDaysToRetain());
    }

    static Metrics toMetrics(TableServiceMetrics tableServiceMetrics) {
        if (tableServiceMetrics == null) {
            return null;
        }
        return new Metrics().setVersion(tableServiceMetrics.getVersion()).setEnabled(tableServiceMetrics.isEnabled()).setIncludeAPIs(tableServiceMetrics.isIncludeApis()).setRetentionPolicy(TableUtils.toRetentionPolicy(tableServiceMetrics.getTableServiceRetentionPolicy()));
    }

    static CorsRule toCorsRule(TableServiceCorsRule corsRule) {
        if (corsRule == null) {
            return null;
        }
        return new CorsRule().setAllowedOrigins(corsRule.getAllowedOrigins()).setAllowedMethods(corsRule.getAllowedMethods()).setAllowedHeaders(corsRule.getAllowedHeaders()).setExposedHeaders(corsRule.getExposedHeaders()).setMaxAgeInSeconds(corsRule.getMaxAgeInSeconds());
    }

    public static TableServiceStatistics toTableServiceStatistics(TableServiceStats tableServiceStats) {
        if (tableServiceStats == null) {
            return null;
        }
        return new TableServiceStatistics(TableUtils.toTableServiceGeoReplication(tableServiceStats.getGeoReplication()));
    }

    static TableServiceGeoReplication toTableServiceGeoReplication(GeoReplication geoReplication) {
        if (geoReplication == null) {
            return null;
        }
        return new TableServiceGeoReplication(TableServiceGeoReplicationStatus.fromString(geoReplication.getStatus().toString()), geoReplication.getLastSyncTime());
    }

    public static String escapeSingleQuotes(String input) {
        if (input == null) {
            return null;
        }
        return input.replace("'", "''");
    }

    public static TableSignedIdentifier toTableSignedIdentifier(SignedIdentifier signedIdentifier) {
        if (signedIdentifier == null) {
            return null;
        }
        return new TableSignedIdentifier(signedIdentifier.getId()).setAccessPolicy(TableUtils.toTableAccessPolicy(signedIdentifier.getAccessPolicy()));
    }

    static TableAccessPolicy toTableAccessPolicy(AccessPolicy accessPolicy) {
        if (accessPolicy == null) {
            return null;
        }
        return new TableAccessPolicy().setExpiresOn(accessPolicy.getExpiry()).setStartsOn(accessPolicy.getStart()).setPermissions(accessPolicy.getPermission());
    }

    public static SignedIdentifier toSignedIdentifier(TableSignedIdentifier tableSignedIdentifier) {
        if (tableSignedIdentifier == null) {
            return null;
        }
        return new SignedIdentifier().setId(tableSignedIdentifier.getId()).setAccessPolicy(TableUtils.toAccessPolicy(tableSignedIdentifier.getAccessPolicy()));
    }

    static AccessPolicy toAccessPolicy(TableAccessPolicy tableAccessPolicy) {
        if (tableAccessPolicy == null) {
            return null;
        }
        return new AccessPolicy().setExpiry(tableAccessPolicy.getExpiresOn()).setStart(tableAccessPolicy.getStartsOn()).setPermission(tableAccessPolicy.getPermissions());
    }

    public static Exception interpretException(Exception ex) {
        Throwable cause;
        Throwable exception = ex;
        if (exception instanceof ExecutionException) {
            exception = exception.getCause();
        }
        if ((cause = exception.getCause()) instanceof TableTransactionFailedException) {
            TableTransactionFailedException failedException = (TableTransactionFailedException)((Object)cause);
            return failedException;
        }
        return (RuntimeException)TableUtils.mapThrowableToTableServiceException(exception);
    }
}

