/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables;

import com.azure.core.annotation.ServiceClientBuilder;
import com.azure.core.client.traits.AzureNamedKeyCredentialTrait;
import com.azure.core.client.traits.AzureSasCredentialTrait;
import com.azure.core.client.traits.ConfigurationTrait;
import com.azure.core.client.traits.ConnectionStringTrait;
import com.azure.core.client.traits.EndpointTrait;
import com.azure.core.client.traits.HttpTrait;
import com.azure.core.client.traits.TokenCredentialTrait;
import com.azure.core.credential.AzureNamedKeyCredential;
import com.azure.core.credential.AzureSasCredential;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelinePosition;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.data.tables.BuilderHelper;
import com.azure.data.tables.TableServiceAsyncClient;
import com.azure.data.tables.TableServiceClient;
import com.azure.data.tables.TableServiceVersion;
import com.azure.data.tables.implementation.StorageAuthenticationSettings;
import com.azure.data.tables.implementation.StorageConnectionString;
import com.azure.data.tables.implementation.StorageEndpoint;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@ServiceClientBuilder(serviceClients={TableServiceClient.class, TableServiceAsyncClient.class})
public final class TableServiceClientBuilder
implements TokenCredentialTrait<TableServiceClientBuilder>,
AzureNamedKeyCredentialTrait<TableServiceClientBuilder>,
ConnectionStringTrait<TableServiceClientBuilder>,
AzureSasCredentialTrait<TableServiceClientBuilder>,
HttpTrait<TableServiceClientBuilder>,
ConfigurationTrait<TableServiceClientBuilder>,
EndpointTrait<TableServiceClientBuilder> {
    private final ClientLogger logger = new ClientLogger(TableServiceClientBuilder.class);
    private final SerializerAdapter serializerAdapter = JacksonAdapter.createDefaultSerializerAdapter();
    private final List<HttpPipelinePolicy> perCallPolicies = new ArrayList<HttpPipelinePolicy>();
    private final List<HttpPipelinePolicy> perRetryPolicies = new ArrayList<HttpPipelinePolicy>();
    private Configuration configuration;
    private String connectionString;
    private String endpoint;
    private HttpClient httpClient;
    private HttpLogOptions httpLogOptions;
    private ClientOptions clientOptions;
    private TableServiceVersion version;
    private HttpPipeline httpPipeline;
    private AzureNamedKeyCredential azureNamedKeyCredential;
    private AzureSasCredential azureSasCredential;
    private TokenCredential tokenCredential;
    private String sasToken;
    private RetryPolicy retryPolicy;
    private RetryOptions retryOptions;
    private boolean enableTenantDiscovery;

    public TableServiceClient buildClient() {
        return new TableServiceClient(this.buildAsyncClient());
    }

    public TableServiceAsyncClient buildAsyncClient() {
        TableServiceVersion serviceVersion = this.version != null ? this.version : TableServiceVersion.getLatest();
        BuilderHelper.validateCredentials(this.azureNamedKeyCredential, this.azureSasCredential, this.tokenCredential, this.sasToken, this.connectionString, this.logger);
        AzureNamedKeyCredential namedKeyCredential = null;
        if (this.connectionString != null) {
            StorageConnectionString storageConnectionString = StorageConnectionString.create(this.connectionString, this.logger);
            StorageEndpoint storageConnectionStringTableEndpoint = storageConnectionString.getTableEndpoint();
            if (storageConnectionStringTableEndpoint == null || storageConnectionStringTableEndpoint.getPrimaryUri() == null) {
                throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'connectionString' is missing the required settings to derive a Tables endpoint."));
            }
            String connectionStringEndpoint = storageConnectionStringTableEndpoint.getPrimaryUri();
            if (this.endpoint == null) {
                this.endpoint = connectionStringEndpoint;
            } else {
                if (this.endpoint.endsWith("/")) {
                    this.endpoint = this.endpoint.substring(0, this.endpoint.length() - 1);
                }
                if (connectionStringEndpoint.endsWith("/")) {
                    connectionStringEndpoint = connectionStringEndpoint.substring(0, connectionStringEndpoint.length() - 1);
                }
                if (!this.endpoint.equals(connectionStringEndpoint)) {
                    throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("'endpoint' points to a different tables endpoint than 'connectionString'."));
                }
            }
            StorageAuthenticationSettings authSettings = storageConnectionString.getStorageAuthSettings();
            if (authSettings.getType() == StorageAuthenticationSettings.Type.ACCOUNT_NAME_KEY) {
                namedKeyCredential = this.azureNamedKeyCredential != null ? this.azureNamedKeyCredential : new AzureNamedKeyCredential(authSettings.getAccount().getName(), authSettings.getAccount().getAccessKey());
            } else if (authSettings.getType() == StorageAuthenticationSettings.Type.SAS_TOKEN) {
                String string = this.sasToken = this.sasToken != null ? this.sasToken : authSettings.getSasToken();
            }
        }
        HttpPipeline pipeline = this.httpPipeline != null ? this.httpPipeline : BuilderHelper.buildPipeline(namedKeyCredential != null ? namedKeyCredential : this.azureNamedKeyCredential, this.azureSasCredential, this.tokenCredential, this.sasToken, this.endpoint, this.retryPolicy, this.retryOptions, this.httpLogOptions, this.clientOptions, this.httpClient, this.perCallPolicies, this.perRetryPolicies, this.configuration, this.logger, this.enableTenantDiscovery);
        return new TableServiceAsyncClient(pipeline, this.endpoint, serviceVersion, this.serializerAdapter);
    }

    public TableServiceClientBuilder connectionString(String connectionString) {
        if (connectionString == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'connectionString' cannot be null."));
        }
        StorageConnectionString.create(connectionString, this.logger);
        this.connectionString = connectionString;
        return this;
    }

    public TableServiceClientBuilder endpoint(String endpoint) {
        if (endpoint == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'endpoint' cannot be null."));
        }
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException ex) {
            throw this.logger.logExceptionAsWarning((RuntimeException)new IllegalArgumentException("'endpoint' must be a valid URL.", ex));
        }
        this.endpoint = endpoint;
        return this;
    }

    public TableServiceClientBuilder pipeline(HttpPipeline pipeline) {
        this.httpPipeline = pipeline;
        return this;
    }

    public TableServiceClientBuilder configuration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public TableServiceClientBuilder sasToken(String sasToken) {
        if (sasToken == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'sasToken' cannot be null."));
        }
        if (sasToken.isEmpty()) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sasToken' cannot be empty."));
        }
        this.sasToken = sasToken;
        return this;
    }

    public TableServiceClientBuilder credential(AzureSasCredential credential) {
        if (credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.azureSasCredential = credential;
        return this;
    }

    public TableServiceClientBuilder credential(AzureNamedKeyCredential credential) {
        if (credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.azureNamedKeyCredential = credential;
        return this;
    }

    public TableServiceClientBuilder credential(TokenCredential credential) {
        if (credential == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'credential' cannot be null."));
        }
        this.tokenCredential = credential;
        return this;
    }

    public TableServiceClientBuilder httpClient(HttpClient httpClient) {
        if (this.httpClient != null && httpClient == null) {
            this.logger.warning("'httpClient' is being set to 'null' when it was previously configured.");
        }
        this.httpClient = httpClient;
        return this;
    }

    public TableServiceClientBuilder httpLogOptions(HttpLogOptions logOptions) {
        this.httpLogOptions = logOptions;
        return this;
    }

    public TableServiceClientBuilder addPolicy(HttpPipelinePolicy pipelinePolicy) {
        if (pipelinePolicy == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new NullPointerException("'pipelinePolicy' cannot be null."));
        }
        if (pipelinePolicy.getPipelinePosition() == HttpPipelinePosition.PER_CALL) {
            this.perCallPolicies.add(pipelinePolicy);
        } else {
            this.perRetryPolicies.add(pipelinePolicy);
        }
        return this;
    }

    public TableServiceClientBuilder serviceVersion(TableServiceVersion serviceVersion) {
        this.version = serviceVersion;
        return this;
    }

    public TableServiceClientBuilder retryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public TableServiceClientBuilder retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public TableServiceClientBuilder clientOptions(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        return this;
    }

    public TableServiceClientBuilder enableTenantDiscovery() {
        this.enableTenantDiscovery = true;
        return this;
    }
}

