/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class TablesInsertEntityHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="Preference-Applied")
    private String preferenceApplied;
    @JsonProperty(value="Content-Type")
    private String contentType;

    public TablesInsertEntityHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.eTag = rawHeaders.getValue("ETag");
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsClientRequestId = rawHeaders.getValue("x-ms-client-request-id");
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
        this.preferenceApplied = rawHeaders.getValue("Preference-Applied");
        this.contentType = rawHeaders.getValue("Content-Type");
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public TablesInsertEntityHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public TablesInsertEntityHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public TablesInsertEntityHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public TablesInsertEntityHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public TablesInsertEntityHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public String getPreferenceApplied() {
        return this.preferenceApplied;
    }

    public TablesInsertEntityHeaders setPreferenceApplied(String preferenceApplied) {
        this.preferenceApplied = preferenceApplied;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public TablesInsertEntityHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }
}

