/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.core.http.HttpHeaders;
import com.azure.core.util.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

public final class TablesQueryEntitiesHeaders {
    @JsonProperty(value="x-ms-version")
    private String xMsVersion;
    @JsonProperty(value="x-ms-continuation-NextPartitionKey")
    private String xMsContinuationNextPartitionKey;
    @JsonProperty(value="x-ms-continuation-NextRowKey")
    private String xMsContinuationNextRowKey;
    @JsonProperty(value="x-ms-request-id")
    private String xMsRequestId;
    @JsonProperty(value="x-ms-client-request-id")
    private String xMsClientRequestId;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;

    public TablesQueryEntitiesHeaders(HttpHeaders rawHeaders) {
        this.xMsVersion = rawHeaders.getValue("x-ms-version");
        this.xMsContinuationNextPartitionKey = rawHeaders.getValue("x-ms-continuation-NextPartitionKey");
        this.xMsContinuationNextRowKey = rawHeaders.getValue("x-ms-continuation-NextRowKey");
        this.xMsRequestId = rawHeaders.getValue("x-ms-request-id");
        this.xMsClientRequestId = rawHeaders.getValue("x-ms-client-request-id");
        if (rawHeaders.getValue("Date") != null) {
            this.dateProperty = new DateTimeRfc1123(rawHeaders.getValue("Date"));
        }
    }

    public String getXMsVersion() {
        return this.xMsVersion;
    }

    public TablesQueryEntitiesHeaders setXMsVersion(String xMsVersion) {
        this.xMsVersion = xMsVersion;
        return this;
    }

    public String getXMsContinuationNextPartitionKey() {
        return this.xMsContinuationNextPartitionKey;
    }

    public TablesQueryEntitiesHeaders setXMsContinuationNextPartitionKey(String xMsContinuationNextPartitionKey) {
        this.xMsContinuationNextPartitionKey = xMsContinuationNextPartitionKey;
        return this;
    }

    public String getXMsContinuationNextRowKey() {
        return this.xMsContinuationNextRowKey;
    }

    public TablesQueryEntitiesHeaders setXMsContinuationNextRowKey(String xMsContinuationNextRowKey) {
        this.xMsContinuationNextRowKey = xMsContinuationNextRowKey;
        return this;
    }

    public String getXMsRequestId() {
        return this.xMsRequestId;
    }

    public TablesQueryEntitiesHeaders setXMsRequestId(String xMsRequestId) {
        this.xMsRequestId = xMsRequestId;
        return this;
    }

    public String getXMsClientRequestId() {
        return this.xMsClientRequestId;
    }

    public TablesQueryEntitiesHeaders setXMsClientRequestId(String xMsClientRequestId) {
        this.xMsClientRequestId = xMsClientRequestId;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public TablesQueryEntitiesHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }
}

