/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.data.tables.implementation.EntityDataModelType;
import com.azure.data.tables.implementation.TablesConstants;
import com.azure.data.tables.implementation.models.TableEntityQueryResponse;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TablesJacksonSerializer
extends JacksonAdapter {
    private static final ClientLogger LOGGER = new ClientLogger(TablesJacksonSerializer.class);

    public void serialize(Object object, SerializerEncoding encoding, OutputStream outputStream) throws IOException {
        outputStream.write(this.serializeToBytes(object, encoding));
    }

    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        return new String(this.serializeToBytes(object, encoding), StandardCharsets.UTF_8);
    }

    public byte[] serializeToBytes(Object object, SerializerEncoding encoding) throws IOException {
        if (object instanceof Map) {
            return super.serializeToBytes(this.insertTypeProperties(object), encoding);
        }
        return super.serializeToBytes(object, encoding);
    }

    private Map<String, Object> insertTypeProperties(Object o) {
        Map map = (Map)o;
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry entry : map.entrySet()) {
            EntityDataModelType typeToTag;
            String propertyName = (String)entry.getKey();
            Object propertyValue = entry.getValue();
            if (propertyValue == null) continue;
            if (propertyValue instanceof Long) {
                result.put(propertyName, String.valueOf(propertyValue));
            } else {
                result.put(propertyName, propertyValue);
            }
            if (TablesConstants.METADATA_KEYS.contains(propertyName) || propertyName.endsWith("@odata.type") || (typeToTag = EntityDataModelType.forClass(propertyValue.getClass())) == null) continue;
            result.putIfAbsent(propertyName + "@odata.type", typeToTag.getEdmType());
        }
        return result;
    }

    public <U> U deserialize(String value, Type type, SerializerEncoding serializerEncoding) throws IOException {
        return this.deserialize(new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8)), type, serializerEncoding);
    }

    public <U> U deserialize(InputStream inputStream, Type type, SerializerEncoding serializerEncoding) throws IOException {
        if (inputStream != null && type == TableEntityQueryResponse.class) {
            try (JsonReader jsonReader = JsonProviders.createReader((InputStream)inputStream);){
                U u = TablesJacksonSerializer.deserializeTableEntityQueryResponse(jsonReader);
                return u;
            }
        }
        if (inputStream != null && TablesJacksonSerializer.shouldGetEntityFieldsAsMap(type)) {
            try (JsonReader jsonReader = JsonProviders.createReader((InputStream)inputStream);){
                Map<String, Object> map = TablesJacksonSerializer.getEntityFieldsAsMap(jsonReader);
                return (U)map;
            }
        }
        return (U)super.deserialize(inputStream, type, serializerEncoding);
    }

    public <U> U deserialize(byte[] bytes, Type type, SerializerEncoding encoding) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return (U)super.deserialize(bytes, type, encoding);
        }
        return this.deserialize(new ByteArrayInputStream(bytes), type, encoding);
    }

    private static boolean shouldGetEntityFieldsAsMap(Type type) {
        return type instanceof ParameterizedType && ((ParameterizedType)type).getRawType() == Map.class;
    }

    private static <U> U deserializeTableEntityQueryResponse(JsonReader jsonReader) throws IOException {
        return (U)jsonReader.readObject(reader -> {
            TableEntityQueryResponse deserializedTableEntityQueryResponse = new TableEntityQueryResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("odata.metadata".equals(fieldName)) {
                    deserializedTableEntityQueryResponse.setOdataMetadata(reader.getString());
                    continue;
                }
                if ("value".equals(fieldName)) {
                    deserializedTableEntityQueryResponse.setValue(reader.readArray(TablesJacksonSerializer::getEntityFieldsAsMap));
                    continue;
                }
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException("Unexpected response format. Response containing a 'value' array must not contain other properties."));
            }
            return deserializedTableEntityQueryResponse;
        });
    }

    private static Map<String, Object> getEntityFieldsAsMap(JsonReader jsonReader) throws IOException {
        return (Map)jsonReader.readObject(reader -> {
            LinkedHashMap<String, EntityInformation> rawEntityMap = new LinkedHashMap<String, EntityInformation>();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("odata.metadata".equals(fieldName)) continue;
                rawEntityMap.put(fieldName, TablesJacksonSerializer.getEntityFieldAsObject(fieldName, reader));
            }
            return TablesJacksonSerializer.processRawEntityMap(rawEntityMap);
        });
    }

    private static Map<String, Object> processRawEntityMap(Map<String, EntityInformation> rawEntityMap) throws IOException {
        LinkedHashMap<String, Object> entityMap = new LinkedHashMap<String, Object>((int)((float)rawEntityMap.size() / 0.7f));
        List odataTypeKeys = rawEntityMap.keySet().stream().filter(key -> key.endsWith("@odata.type")).collect(Collectors.toList());
        for (String string : odataTypeKeys) {
            Object value;
            EntityInformation keyInformation = rawEntityMap.remove(string);
            entityMap.put(string, keyInformation.value);
            String expectedValueField = string.substring(0, string.length() - "@odata.type".length());
            EntityInformation entityInformation = rawEntityMap.remove(expectedValueField);
            if (entityInformation == null) continue;
            EntityDataModelType type = EntityDataModelType.fromString(String.valueOf(keyInformation.value));
            if (type == null) {
                LOGGER.warning("'{}' value has unknown OData type {}", new Object[]{expectedValueField, keyInformation.value});
                if (TablesJacksonSerializer.isJsonStruct(entityInformation.entityToken)) {
                    try (JsonReader structReader = JsonProviders.createReader((String)entityInformation.rawJson);){
                        value = structReader.readUntyped();
                    }
                } else {
                    value = entityInformation.value;
                }
            } else {
                try {
                    value = type.deserialize(entityInformation.rawJson);
                }
                catch (Exception e) {
                    throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("'%s' value is not a valid %s.", expectedValueField, type.getEdmType()), e));
                }
            }
            entityMap.put(expectedValueField, value);
        }
        for (Map.Entry entry : rawEntityMap.entrySet()) {
            Object value;
            if (TablesJacksonSerializer.isJsonStruct(((EntityInformation)entry.getValue()).entityToken)) {
                try (JsonReader structReader = JsonProviders.createReader((String)((EntityInformation)entry.getValue()).rawJson);){
                    value = structReader.readUntyped();
                }
            } else {
                value = ((EntityInformation)entry.getValue()).value;
            }
            entityMap.put((String)entry.getKey(), value);
        }
        return entityMap;
    }

    private static EntityInformation getEntityFieldAsObject(String fieldName, JsonReader jsonReader) throws IOException {
        JsonToken entityToken = jsonReader.currentToken();
        if ("Timestamp".equals(fieldName)) {
            return new EntityInformation(entityToken, jsonReader.getText(), EntityDataModelType.DATE_TIME.deserialize(jsonReader.getString()));
        }
        if (TablesConstants.METADATA_KEYS.contains(fieldName) || fieldName.endsWith("@odata.type")) {
            return new EntityInformation(entityToken, null, jsonReader.getString());
        }
        if (TablesJacksonSerializer.isJsonStruct(entityToken)) {
            return new EntityInformation(entityToken, jsonReader.readChildren(), null);
        }
        return new EntityInformation(entityToken, jsonReader.getText(), jsonReader.readUntyped());
    }

    private static boolean isJsonStruct(JsonToken jsonToken) {
        return jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY;
    }

    private static final class EntityInformation {
        private final JsonToken entityToken;
        private final String rawJson;
        private final Object value;

        EntityInformation(JsonToken entityToken, String rawJson, Object value) {
            this.entityToken = entityToken;
            this.rawJson = rawJson;
            this.value = value;
        }
    }
}

