/*
 * Decompiled with CFR 0.152.
 */
package com.azure.data.tables.implementation.models;

import com.azure.data.tables.implementation.models.OdataMetadataFormat;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class QueryOptions
implements JsonSerializable<QueryOptions> {
    private OdataMetadataFormat format;
    private Integer top;
    private String select;
    private String filter;

    public OdataMetadataFormat getFormat() {
        return this.format;
    }

    public QueryOptions setFormat(OdataMetadataFormat format) {
        this.format = format;
        return this;
    }

    public Integer getTop() {
        return this.top;
    }

    public QueryOptions setTop(Integer top) {
        this.top = top;
        return this;
    }

    public String getSelect() {
        return this.select;
    }

    public QueryOptions setSelect(String select) {
        this.select = select;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public QueryOptions setFilter(String filter) {
        this.filter = filter;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("Format", this.format == null ? null : this.format.toString());
        jsonWriter.writeNumberField("Top", (Number)this.top);
        jsonWriter.writeStringField("Select", this.select);
        jsonWriter.writeStringField("Filter", this.filter);
        return jsonWriter.writeEndObject();
    }

    public static QueryOptions fromJson(JsonReader jsonReader) throws IOException {
        return (QueryOptions)jsonReader.readObject(reader -> {
            QueryOptions deserializedQueryOptions = new QueryOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("Format".equals(fieldName)) {
                    deserializedQueryOptions.format = OdataMetadataFormat.fromString(reader.getString());
                    continue;
                }
                if ("Top".equals(fieldName)) {
                    deserializedQueryOptions.top = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("Select".equals(fieldName)) {
                    deserializedQueryOptions.select = reader.getString();
                    continue;
                }
                if ("Filter".equals(fieldName)) {
                    deserializedQueryOptions.filter = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedQueryOptions;
        });
    }
}

